/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.dependencies;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.Node;

@Rule(key="LibraryDependencyCheck")
public class LibraryDependencyCheck
extends AbstractPageCheck {
    private static final String DEFAULT_LIBRARIES = "";
    private static final String DEFAULT_MESSAGE = "Remove the usage of this library which is not allowed.";
    @RuleProperty(key="libraries", description="Comma-separated list of Java packages or classes, such as java.sql or java.util.ArrayList", defaultValue="")
    public String libraries = "";
    @RuleProperty(key="message", description="Issue message which is displayed in case of violation", defaultValue="Remove the usage of this library which is not allowed.")
    public String message = "Remove the usage of this library which is not allowed.";
    private List<String> librariesList;

    @Override
    public void startDocument(List<Node> nodes) {
        this.librariesList = Arrays.stream(this.libraries.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public void directive(DirectiveNode node) {
        if (node.isJsp() && "page".equalsIgnoreCase(node.getNodeName())) {
            for (Attribute attribute : node.getAttributes()) {
                if (!this.isIllegalImport(attribute)) continue;
                this.createViolation(node.getStartLinePosition(), this.message);
            }
        }
    }

    private boolean isIllegalImport(Attribute a) {
        if ("import".equals(a.getName())) {
            for (String library : this.librariesList) {
                if (!a.getValue().contains(library)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void expression(ExpressionNode node) {
        for (String library : this.librariesList) {
            if (!node.getCode().contains(library)) continue;
            this.createViolation(node.getStartLinePosition(), this.message);
        }
    }
}

