/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.coding;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;
import org.sonar.plugins.html.node.TextNode;

@Rule(key="FileLengthCheck")
public class FileLengthCheck
extends AbstractPageCheck {
    private static final int DEFAULT_MAX_FILE_LENGTH = 1000;
    @RuleProperty(key="maxLength", description="Maximum authorized lines of code in a file.", defaultValue="1000")
    public int maxLength = 1000;
    private int maxLine = 0;

    @Override
    public void startDocument(List<Node> nodes) {
        this.maxLine = 0;
    }

    @Override
    public void startElement(TagNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    @Override
    public void endElement(TagNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    @Override
    public void characters(TextNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    @Override
    public void comment(CommentNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    @Override
    public void directive(DirectiveNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    @Override
    public void expression(ExpressionNode node) {
        this.setMaxLine(node.getEndLinePosition());
    }

    private void setMaxLine(int line) {
        if (line > this.maxLine) {
            this.maxLine = line;
        }
    }

    @Override
    public void endDocument() {
        int loc = this.getHtmlSourceCode().getDetailedLinesOfCode().size();
        if (loc > this.maxLength) {
            this.createViolation(0, "Current file has " + loc + " lines, which is greater than " + this.maxLength + " authorized. Split it into smaller files.");
        }
    }
}

