/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io.sink;

import com.thoughtworks.xstream.XStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.smooks.api.io.Sink;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.bean.context.StandaloneBeanContext;
import org.smooks.io.payload.Export;
import org.smooks.io.payload.SinkExtractor;

public class JavaSink
implements Sink,
SinkExtractor<JavaSink> {
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    private Map<String, Object> resultMap;

    public JavaSink() {
        this(true);
    }

    public JavaSink(boolean preserveOrder) {
        this.resultMap = preserveOrder ? new LinkedHashMap<String, Object>() : new HashMap<String, Object>();
    }

    public JavaSink(Map<String, Object> resultMap) {
        AssertArgument.isNotNull(resultMap, (String)"resultMap");
        this.resultMap = resultMap;
    }

    public Object getBean(String name) {
        return this.resultMap.get(name);
    }

    public <T> T getBean(Class<T> beanType) {
        return StandaloneBeanContext.getBean(beanType, this.resultMap);
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    public String toString() {
        StringWriter stringBuilder = new StringWriter();
        XStream xstream = new XStream();
        if (this.resultMap != null && !this.resultMap.isEmpty()) {
            Set<Map.Entry<String, Object>> entries = this.resultMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                stringBuilder.write(entry.getKey() + ":" + LINE_SEPARATOR);
                stringBuilder.write(xstream.toXML(entry.getValue()) + LINE_SEPARATOR + LINE_SEPARATOR);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Object extractFromSink(JavaSink sink, Export export) {
        Set<String> extractSet = export.getExtractSet();
        if (extractSet == null) {
            return this.extractBeans(sink, sink.getResultMap().keySet());
        }
        if (extractSet.size() == 1) {
            return sink.getBean(extractSet.iterator().next());
        }
        return this.extractBeans(sink, extractSet);
    }

    private Object extractBeans(JavaSink result, Collection<String> extractSet) {
        ResultMap<String, Object> extractedObjects = new ResultMap<String, Object>();
        for (String extract : extractSet) {
            Object bean = result.getBean(extract);
            if (bean == null) continue;
            extractedObjects.put(extract, bean);
        }
        return extractedObjects;
    }

    public static class ResultMap<K, V>
    extends HashMap<K, V> {
    }
}

