/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io.payload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.io.Sink;
import org.smooks.assertion.AssertArgument;
import org.smooks.io.payload.Export;
import org.smooks.io.payload.SinkExtractor;
import org.smooks.support.ClassUtils;

public class Exports
implements ContentHandler {
    private final Map<Class<?>, Export> exportsMap = new HashMap();
    @Inject
    private ApplicationContext applicationContext;

    public Exports() {
    }

    public Exports(Export export) {
        this.addExport(export);
    }

    public Exports(Set<Export> exportTypes) {
        for (Export export : exportTypes) {
            this.addExport(export);
        }
    }

    public Exports(Class<?> sinkType) {
        AssertArgument.isNotNull(sinkType, (String)"sinkType");
        this.addExport(new Export(sinkType));
    }

    public Exports(String sinkType) {
        AssertArgument.isNotNull((Object)sinkType, (String)"sinkType");
        this.addExport(new Export(this.getClassForType(sinkType)));
    }

    private Class<?> getClassForType(String type) {
        try {
            return ClassUtils.forName((String)type, Exports.class);
        }
        catch (ClassNotFoundException e) {
            throw new SmooksException("Could not load class for type [" + type + "].");
        }
    }

    public void addExport(Export export) {
        this.exportsMap.put(export.getType(), export);
    }

    public Collection<Export> getExports() {
        return Collections.unmodifiableCollection(this.exportsMap.values());
    }

    public Set<Class<?>> getSinkTypes() {
        return Collections.unmodifiableSet(this.exportsMap.keySet());
    }

    public boolean hasExports() {
        return !this.exportsMap.isEmpty();
    }

    public Export getExport(Class<?> type) {
        return this.exportsMap.get(type);
    }

    public Sink[] createSinks() {
        HashSet<Sink> sinks = new HashSet<Sink>();
        for (Class<?> sinkTypeClass : this.exportsMap.keySet()) {
            sinks.add(Exports.createSinkInstance(sinkTypeClass));
        }
        return sinks.toArray(new Sink[0]);
    }

    public Collection<Export> getProducts() {
        return this.getExports();
    }

    public static List<Object> extractSinks(Sink[] sinks, Exports exports) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Sink sink : sinks) {
            if (sink instanceof SinkExtractor) {
                SinkExtractor e = (SinkExtractor)sink;
                objects.add(e.extractFromSink(sink, exports.getExport(sink.getClass())));
                continue;
            }
            objects.add(sink);
        }
        return objects;
    }

    private static Sink createSinkInstance(Class<?> sinkTypeClass) {
        try {
            return (Sink)sinkTypeClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksException("Could not instantiate instance for sink type [" + sinkTypeClass.getName() + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksException("Could not create instance for sink type [" + sinkTypeClass.getName() + "]", (Throwable)e);
        }
    }
}

