/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io.payload;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.smooks.api.ApplicationContext;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.engine.lookup.ExportsLookup;
import org.smooks.io.payload.Exports;

public class Export
implements ContentHandler {
    @Inject
    private Optional<String> name;
    @Inject
    private Class<?> type;
    @Inject
    private Optional<String> extract;
    private Set<String> extractSet;
    @Inject
    private ApplicationContext applicationContext;

    public Export() {
    }

    public Export(Class<?> type) {
        this.type = type;
    }

    public Export(Class<?> type, String name) {
        this(type);
        this.name = Optional.ofNullable(name);
    }

    public Export(Class<?> type, String name, String extract) {
        this(type, name);
        this.extract = Optional.ofNullable(extract);
        this.initExtractSet();
    }

    @PostConstruct
    public void postConstruct() {
        this.initExtractSet();
        Exports exports = (Exports)this.applicationContext.getRegistry().lookup((Function)new ExportsLookup());
        exports.addExport(this);
    }

    private void initExtractSet() {
        this.extract.ifPresent(s -> {
            this.extractSet = new HashSet<String>(Arrays.asList(s.split(",")));
        });
    }

    public String getName() {
        return this.name.get();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getExtract() {
        return this.extract.get();
    }

    public Set<String> getExtractSet() {
        return this.extractSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extract == null ? 0 : this.extract.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export)obj;
        return Objects.equals(this.type, other.type) && (this.extract == other.extract || this.extract != null && this.extract.isPresent() && this.extract.get().equals(other.extract == null ? null : other.extract.orElse(null))) && (this.name == other.name || this.name != null && this.name.isPresent() && this.name.get().equals(other.name == null ? null : other.name.orElse(null)));
    }

    public String toString() {
        return "Export [type=" + this.type.getName() + ", name=" + this.name + ", extract=" + this.extract + "]";
    }
}

