/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.IOException;
import java.io.Writer;
import org.smooks.support.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DomSerializer {
    private final Boolean closeEmptyElements;
    private final Boolean rewriteEntities;

    public DomSerializer(Boolean closeEmptyElements, Boolean rewriteEntities) {
        this.closeEmptyElements = closeEmptyElements;
        this.rewriteEntities = rewriteEntities;
    }

    public boolean isRewriteEntities() {
        return this.rewriteEntities;
    }

    public void writeStartElement(Element element, Writer writer) throws IOException {
        writer.write(60);
        writer.write(element.getTagName());
        this.writeAttributes(element.getAttributes(), writer);
        if (!this.closeEmptyElements.booleanValue() || element.hasChildNodes()) {
            writer.write(62);
        }
    }

    public void writeAttributes(NamedNodeMap attributes, Writer writer) throws IOException {
        int attribCount = attributes.getLength();
        for (int i = 0; i < attribCount; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String attribValue = attribute.getValue();
            int enclosingChar = 34;
            writer.write(32);
            writer.write(attribute.getName());
            writer.write(61);
            if (this.rewriteEntities.booleanValue()) {
                writer.write(34);
                XmlUtils.encodeAttributeValue((char[])attribValue.toCharArray(), (int)0, (int)attribValue.length(), (Writer)writer);
                writer.write(34);
                continue;
            }
            if (attribValue.indexOf(34) != -1) {
                enclosingChar = 39;
            }
            writer.write(enclosingChar);
            writer.write(attribValue);
            writer.write(enclosingChar);
        }
    }

    public void writeEndElement(Element element, Writer writer) throws IOException {
        if (this.closeEmptyElements.booleanValue() && !element.hasChildNodes()) {
            writer.write("/>");
        } else {
            writer.write("</");
            writer.write(element.getTagName());
            writer.write(62);
        }
    }

    public void writeCharacterData(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 4: {
                this.writeElementCDATA((CDATASection)node, writer);
                break;
            }
            case 8: {
                this.writeElementComment((Comment)node, writer);
                break;
            }
            case 5: {
                this.writeElementEntityRef((EntityReference)node, writer);
                break;
            }
            case 3: {
                if (this.rewriteEntities.booleanValue()) {
                    String textString = ((Text)node).getData();
                    XmlUtils.encodeTextValue((char[])textString.toCharArray(), (int)0, (int)textString.length(), (Writer)writer);
                    break;
                }
                writer.write(((Text)node).getData());
                break;
            }
            default: {
                throw new IOException("writeElementNode not implemented yet. Node: " + node.getNodeValue() + ", node: [" + node + "]");
            }
        }
    }

    public void writeElementComment(Comment comment, Writer writer) throws IOException {
        writer.write("<!--");
        writer.write(comment.getData());
        writer.write("-->");
    }

    public void writeElementEntityRef(EntityReference entityRef, Writer writer) throws IOException {
        writer.write(38);
        writer.write(entityRef.getNodeName());
        writer.write(59);
    }

    public void writeElementCDATA(CDATASection cdata, Writer writer) throws IOException {
        writer.write("<![CDATA[");
        writer.write(cdata.getData());
        writer.write("]]>");
    }

    public Boolean getCloseEmptyElements() {
        return this.closeEmptyElements;
    }

    public Boolean getRewriteEntities() {
        return this.rewriteEntities;
    }
}

