/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.smooks;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.smooks.Smooks;
import org.smooks.annotation.AnnotationManager;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.ExecutionContext;
import org.smooks.api.NotAppContextScoped;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.io.Sink;
import org.smooks.api.lifecycle.PostFragmentLifecycle;
import org.smooks.api.lifecycle.PreExecutionLifecycle;
import org.smooks.api.memento.MementoCaretaker;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.DefaultFilterSettings;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.sax.ng.pointer.EventPointer;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.engine.memento.SimpleVisitorMemento;
import org.smooks.engine.memento.VisitorMemento;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;
import org.smooks.engine.resource.config.SystemResourceConfigSeqFactory;
import org.smooks.engine.resource.visitor.dom.DOMModel;
import org.smooks.engine.resource.visitor.smooks.ChildEventListener;
import org.smooks.io.DomSerializer;
import org.smooks.io.FragmentWriter;
import org.smooks.io.ResourceWriter;
import org.smooks.io.Stream;
import org.smooks.io.sink.WriterSink;
import org.smooks.io.source.DOMSource;
import org.smooks.support.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NestedSmooksVisitor
implements BeforeVisitor,
AfterVisitor,
Consumer,
PreExecutionLifecycle,
PostFragmentLifecycle {
    static final TypedKey<ExecutionContext> PIPELINE_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY = TypedKey.of();
    protected static final TypedKey<DocumentBuilder> CACHED_DOCUMENT_BUILDER_TYPED_KEY = TypedKey.of();
    protected BeanId bindBeanId;
    protected Action action;
    @Inject
    @Named(value="action")
    protected Optional<Action> actionOptional;
    @Inject
    @Named(value="bindId")
    protected Optional<String> bindIdOptional;
    @Inject
    @Named(value="outputStreamResource")
    protected Optional<String> outputStreamResourceOptional;
    @Inject
    protected ResourceConfig resourceConfig;
    @Inject
    protected Integer maxNodeDepth = 1;
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    @Named(value="entities.rewrite")
    protected Boolean rewriteEntities = true;
    protected ResourceConfigSeq resourceConfigSeq;
    protected Smooks pipeline;
    protected DomSerializer domSerializer;

    @PostConstruct
    public void postConstruct() throws SAXException, IOException, URISyntaxException, ClassNotFoundException {
        if (this.pipeline == null) {
            if (!this.resourceConfig.getParameters("smooksResourceList").isEmpty()) {
                ByteArrayInputStream smooksResourceList = new ByteArrayInputStream(((String)this.resourceConfig.getParameter("smooksResourceList", String.class).getValue()).getBytes());
                this.resourceConfigSeq = this.applicationContext.getResourceConfigLoader().load((InputStream)smooksResourceList, "./", this.applicationContext.getClassLoader());
            } else {
                DefaultResourceConfig resourceConfig = new DefaultResourceConfig("*", new Properties());
                resourceConfig.setResource("org.smooks.engine.resource.visitor.SimpleSerializerVisitor");
                this.resourceConfigSeq = new DefaultResourceConfigSeq("./");
                this.resourceConfigSeq.add((ResourceConfig)resourceConfig);
            }
            this.pipeline = new Smooks(this.newPipelineApplicationContext(this.applicationContext));
            for (ResourceConfig resourceConfig : this.resourceConfigSeq) {
                this.pipeline.addResourceConfig(resourceConfig);
            }
        }
        this.initRegistry();
        this.action = this.actionOptional.orElse(null);
        if (this.action != null) {
            if (this.action == Action.BIND_TO) {
                AssertArgument.isNotNull(this.bindIdOptional.orElse(null), (String)"bindId");
                this.bindBeanId = this.applicationContext.getBeanIdStore().register(this.bindIdOptional.get());
            } else if (this.action == Action.OUTPUT_TO) {
                AssertArgument.isNotNull(this.outputStreamResourceOptional.orElse(null), (String)"outputStreamResource");
            }
        }
        this.domSerializer = new DomSerializer(false, this.rewriteEntities);
    }

    protected void initRegistry() {
        Registry pipelineRegistry = this.pipeline.getApplicationContext().getRegistry();
        pipelineRegistry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/pipeline-interceptors.xml", this.pipeline.getApplicationContext().getClassLoader(), this.pipeline.getApplicationContext().getResourceLocator(), this.applicationContext.getResourceConfigLoader()).create());
        Map pipelineRegistryEntries = (Map)this.applicationContext.getRegistry().lookup(entries -> {
            HashMap notAppContextScopedEntries = new HashMap();
            for (Map.Entry entry : entries.entrySet()) {
                if (!(entry.getValue() instanceof NotAppContextScoped.Ref) && AnnotationManager.getAnnotatedClass(entry.getValue().getClass()).getAnnotation(NotAppContextScoped.class) == null || pipelineRegistry.lookup(entry.getKey()) != null) continue;
                notAppContextScopedEntries.put(entry.getKey(), entry.getValue());
            }
            return notAppContextScopedEntries;
        });
        for (Map.Entry pipelineRegistryEntry : pipelineRegistryEntries.entrySet()) {
            pipelineRegistry.registerObject(pipelineRegistryEntry.getKey(), pipelineRegistryEntry.getValue());
        }
    }

    public void onPreExecution(ExecutionContext executionContext) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException((Throwable)e);
        }
        executionContext.put(CACHED_DOCUMENT_BUILDER_TYPED_KEY, (Object)documentBuilder);
    }

    protected Node deAttach(Node node, ExecutionContext executionContext) {
        Document document = ((DocumentBuilder)executionContext.get(CACHED_DOCUMENT_BUILDER_TYPED_KEY)).newDocument();
        document.setStrictErrorChecking(false);
        Node copyNode = document.importNode(node, true);
        document.appendChild(copyNode);
        return copyNode;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        Writer nodeWriter;
        Node deAttachedVistedNode = this.deAttach(element, executionContext);
        NodeFragment visitedFragment = new NodeFragment(element);
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Node>(visitedFragment, (Visitor)this, deAttachedVistedNode));
        NodeFragment deAttachedVisitedNodeFragment = new NodeFragment(deAttachedVistedNode);
        if (this.action == null) {
            this.filterSource(visitedFragment, deAttachedVisitedNodeFragment, Stream.out(executionContext), executionContext, VisitSequence.BEFORE);
            nodeWriter = Stream.out(executionContext);
        } else if (this.action == Action.OUTPUT_TO) {
            ResourceWriter resourceWriter = new ResourceWriter(executionContext, this.outputStreamResourceOptional.get());
            if (resourceWriter.getDelegateWriter() == null) {
                this.filterSource(visitedFragment, deAttachedVisitedNodeFragment, null, executionContext, VisitSequence.BEFORE);
                nodeWriter = null;
            } else {
                executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<ResourceWriter>(deAttachedVisitedNodeFragment, (Visitor)this, resourceWriter));
                this.filterSource(visitedFragment, deAttachedVisitedNodeFragment, resourceWriter, executionContext, VisitSequence.BEFORE);
                nodeWriter = resourceWriter.getDelegateWriter();
            }
        } else if (this.action == Action.PREPEND_BEFORE || this.action == Action.PREPEND_AFTER) {
            nodeWriter = this.prependBefore(visitedFragment, this.action, (Element)deAttachedVisitedNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.APPEND_BEFORE || this.action == Action.APPEND_AFTER) {
            FragmentWriter fragmentWriter = new FragmentWriter(executionContext, deAttachedVisitedNodeFragment);
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn()) {
                try {
                    this.domSerializer.writeStartElement(element, fragmentWriter);
                }
                catch (IOException e) {
                    throw new SmooksException((Throwable)e);
                }
            }
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(deAttachedVisitedNodeFragment, (Visitor)this, fragmentWriter));
            this.filterSource(visitedFragment, deAttachedVisitedNodeFragment, fragmentWriter, executionContext, VisitSequence.BEFORE);
            nodeWriter = fragmentWriter;
        } else if (this.action == Action.REPLACE) {
            nodeWriter = this.replaceBefore(visitedFragment, deAttachedVisitedNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.BIND_TO) {
            nodeWriter = new StringWriter();
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Writer>(deAttachedVisitedNodeFragment, (Visitor)this, nodeWriter));
            this.filterSource(visitedFragment, deAttachedVisitedNodeFragment, nodeWriter, executionContext, VisitSequence.BEFORE);
        } else {
            throw new UnsupportedOperationException();
        }
        ChildEventListener childEventListener = new ChildEventListener(this, nodeWriter, visitedFragment, executionContext);
        executionContext.getContentDeliveryRuntime().addExecutionEventListener((ExecutionEventListener)childEventListener);
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<ChildEventListener>(visitedFragment, (Visitor)this, childEventListener));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        NodeFragment visitedFragment = new NodeFragment(element);
        SimpleVisitorMemento<Element> deAttachedNodeMemento = new SimpleVisitorMemento<Element>(visitedFragment, (Visitor)this, element);
        executionContext.getMementoCaretaker().restore(deAttachedNodeMemento);
        NodeFragment deAttachedNodeFragment = new NodeFragment((Node)deAttachedNodeMemento.getState());
        if (this.action == null) {
            this.filterSource(visitedFragment, deAttachedNodeFragment, Stream.out(executionContext), executionContext, VisitSequence.AFTER);
        } else if (this.action == Action.OUTPUT_TO) {
            ResourceWriter resourceWriter = (ResourceWriter)((SimpleVisitorMemento)executionContext.getMementoCaretaker().stash(new SimpleVisitorMemento<ResourceWriter>(deAttachedNodeFragment, (Visitor)this, new ResourceWriter(executionContext, this.outputStreamResourceOptional.get())), resourceWriterMemento -> resourceWriterMemento)).getState();
            this.filterSource(visitedFragment, deAttachedNodeFragment, resourceWriter, executionContext, VisitSequence.AFTER);
        } else if (this.action == Action.APPEND_BEFORE || this.action == Action.APPEND_AFTER) {
            this.append(visitedFragment, (Element)deAttachedNodeFragment.unwrap(), this.action, executionContext);
        } else if (this.action == Action.PREPEND_BEFORE || this.action == Action.PREPEND_AFTER) {
            this.prependAfter(visitedFragment, (Element)deAttachedNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.REPLACE) {
            this.replaceAfter(visitedFragment, deAttachedNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.BIND_TO) {
            SimpleVisitorMemento<StringWriter> memento = new SimpleVisitorMemento<StringWriter>(deAttachedNodeFragment, (Visitor)this, new StringWriter());
            executionContext.getMementoCaretaker().restore(memento);
            this.filterSource(visitedFragment, deAttachedNodeFragment, (Writer)memento.getState(), executionContext, VisitSequence.AFTER);
            executionContext.getBeanContext().addBean(this.bindBeanId, (Object)((StringWriter)memento.getState()).toString(), (Fragment)deAttachedNodeFragment);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected Writer replaceBefore(Fragment<Node> visitedNodeFragment, Node rootNode, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootNode, true);
        FragmentWriter fragmentWriter = new FragmentWriter(executionContext, rootNodeFragment, false);
        try {
            fragmentWriter.park();
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, fragmentWriter));
        this.filterSource(visitedNodeFragment, rootNodeFragment, fragmentWriter, executionContext, VisitSequence.BEFORE);
        return fragmentWriter;
    }

    protected void replaceAfter(Fragment<Node> visitedNodeFragment, Node rootNode, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootNode);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterVisitorMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, new NodeFragment(rootNode)));
        executionContext.getMementoCaretaker().restore(fragmentWriterVisitorMemento);
        this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterVisitorMemento.getState(), executionContext, VisitSequence.AFTER);
    }

    protected Writer prependBefore(Fragment<Node> visitedNodeFragment, Action action, Element rootElement, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement, true);
        FragmentWriter fragmentWriter = new FragmentWriter(executionContext, rootNodeFragment, false);
        try {
            fragmentWriter.park();
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.PREPEND_AFTER) {
                this.domSerializer.writeStartElement(rootElement, fragmentWriter);
            }
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, fragmentWriter));
            this.filterSource(visitedNodeFragment, rootNodeFragment, fragmentWriter, executionContext, VisitSequence.BEFORE);
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
        return fragmentWriter;
    }

    protected void prependAfter(Fragment<Node> visitedNodeFragment, Element rootElement, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, rootNodeFragment));
        executionContext.getMementoCaretaker().restore(fragmentWriterMemento);
        this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterMemento.getState(), executionContext, VisitSequence.AFTER);
        try {
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && this.action == Action.PREPEND_BEFORE) {
                this.domSerializer.writeStartElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn()) {
                ((FragmentWriter)fragmentWriterMemento.getState()).write(XmlUtils.serialize((NodeList)rootElement.getChildNodes(), (boolean)Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)executionContext.getApplicationContext().getRegistry().lookup((Function)new GlobalParamsLookup())).getParameterValue("close.empty.elements"))));
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    protected void append(Fragment<Node> visitedNodeFragment, Element rootElement, Action action, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, rootNodeFragment));
        executionContext.getMementoCaretaker().restore(fragmentWriterMemento);
        try {
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.APPEND_AFTER) {
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
            this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterMemento.getState(), executionContext, VisitSequence.AFTER);
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.APPEND_BEFORE) {
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    protected void filterSource(Fragment<Node> originalVisitedNodeFragment, Fragment<Node> deAttachedVisitedNodeFragment, Writer writer, ExecutionContext executionContext, VisitSequence visitSequence) {
        VisitorMemento<Object> pipelineExecutionContextMemento;
        MementoCaretaker mementoCaretaker = executionContext.getMementoCaretaker();
        if (mementoCaretaker.exists(new VisitorMemento(originalVisitedNodeFragment, (Visitor)this, PIPELINE_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY))) {
            pipelineExecutionContextMemento = new VisitorMemento(originalVisitedNodeFragment, (Visitor)this, PIPELINE_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY);
            mementoCaretaker.restore(pipelineExecutionContextMemento);
        } else {
            ExecutionContext pipelineExecutionContext = this.pipeline.createExecutionContext();
            pipelineExecutionContext.setContentEncoding(executionContext.getContentEncoding());
            pipelineExecutionContext.setBeanContext(executionContext.getBeanContext());
            pipelineExecutionContext.put(DOMModel.DOM_MODEL_TYPED_KEY, (Object)DOMModel.getModel(executionContext));
            pipelineExecutionContextMemento = new VisitorMemento<ExecutionContext>(originalVisitedNodeFragment, (Visitor)this, PIPELINE_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY, pipelineExecutionContext);
            mementoCaretaker.capture(pipelineExecutionContextMemento);
        }
        Document eventPointerDocument = ((DocumentBuilder)executionContext.get(CACHED_DOCUMENT_BUILDER_TYPED_KEY)).newDocument();
        eventPointerDocument.setStrictErrorChecking(false);
        EventPointer eventPointer = new EventPointer(eventPointerDocument, visitSequence);
        eventPointerDocument.appendChild(eventPointer.getPointerNode());
        ExecutionContext pipelineExecutionContext = (ExecutionContext)pipelineExecutionContextMemento.getState();
        pipelineExecutionContext.put(eventPointer.getReference(), (Object)((Node)deAttachedVisitedNodeFragment.unwrap()));
        if (writer == null) {
            this.pipeline.filterSource(pipelineExecutionContext, new DOMSource(eventPointerDocument), new Sink[0]);
        } else {
            this.pipeline.filterSource(pipelineExecutionContext, new DOMSource(eventPointerDocument), new WriterSink<Writer>(writer));
        }
    }

    public int getMaxNodeDepth() {
        if (this.action != null && (this.action.equals((Object)Action.PREPEND_BEFORE) || this.action.equals((Object)Action.PREPEND_AFTER))) {
            return Integer.MAX_VALUE;
        }
        return this.maxNodeDepth == 0 ? Integer.MAX_VALUE : this.maxNodeDepth;
    }

    public boolean consumes(Object object) {
        return this.outputStreamResourceOptional.map(os -> os.equals(object)).orElse(false);
    }

    public void onPostFragment(Fragment<?> fragment, ExecutionContext executionContext) {
        SimpleVisitorMemento<ChildEventListener> childEventListenerMemento = new SimpleVisitorMemento<ChildEventListener>(fragment, (Visitor)this, new ChildEventListener(this, null, null, null));
        executionContext.getMementoCaretaker().restore(childEventListenerMemento);
        executionContext.getContentDeliveryRuntime().removeExecutionEventListener((ExecutionEventListener)childEventListenerMemento.getState());
    }

    public void setMaxNodeDepth(Integer maxNodeDepth) {
        this.maxNodeDepth = maxNodeDepth;
    }

    public Smooks getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Smooks pipeline) {
        this.pipeline = pipeline;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setResourceConfigSeq(ResourceConfigSeq resourceConfigSeq) {
        this.resourceConfigSeq = resourceConfigSeq;
    }

    public void setAction(Optional<Action> actionOptional) {
        this.actionOptional = actionOptional;
    }

    public void setBindIdOptional(Optional<String> bindIdOptional) {
        this.bindIdOptional = bindIdOptional;
    }

    public Optional<String> getOutputStreamResourceOptional() {
        return this.outputStreamResourceOptional;
    }

    public void setOutputStreamResourceOptional(Optional<String> outputStreamResourceOptional) {
        this.outputStreamResourceOptional = outputStreamResourceOptional;
    }

    @PreDestroy
    public void preDestroy() {
        if (this.pipeline != null) {
            this.pipeline.close();
        }
    }

    protected ApplicationContext newPipelineApplicationContext(ApplicationContext parentApplicationContext) {
        ApplicationContextBuilder applicationContextBuilder = ServiceLoader.load(ApplicationContextBuilder.class).iterator().next();
        if (applicationContextBuilder instanceof DefaultApplicationContextBuilder) {
            applicationContextBuilder = ((DefaultApplicationContextBuilder)applicationContextBuilder).withSystemResources(false);
        }
        return applicationContextBuilder.withFilterSettings(new DefaultFilterSettings().setCloseSink(false).setReaderPoolSize(-1).setMaxNodeDepth(this.maxNodeDepth == 0 ? Integer.MAX_VALUE : this.maxNodeDepth)).withClassLoader(parentApplicationContext.getClassLoader()).withResourceLocator(parentApplicationContext.getResourceLocator()).withBeanIdStore(parentApplicationContext.getBeanIdStore()).build();
    }

    public static enum Action {
        REPLACE,
        PREPEND_BEFORE,
        PREPEND_AFTER,
        APPEND_BEFORE,
        APPEND_AFTER,
        BIND_TO,
        OUTPUT_TO;

    }
}

