/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.dom;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.lifecycle.DOMFilterLifecycle;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.SerializerVisitor;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.event.ResourceTargetingExecutionEvent;
import org.smooks.engine.delivery.event.StartFragmentExecutionEvent;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.lifecycle.SerializationStartedDOMFilterLifecyclePhase;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.engine.lookup.InstanceLookup;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.visitor.dom.DefaultDOMSerializerVisitor;
import org.smooks.engine.xml.DocType;
import org.smooks.support.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Serializer.class);
    private final Node node;
    private final ExecutionContext executionContext;
    private final ContentHandlerBindingIndex<SerializerVisitor> serializerVisitorIndex;
    private final ContentDeliveryRuntime contentDeliveryRuntime;
    private DefaultDOMSerializerVisitor defaultSerializationUnit;
    private final List globalSUs;
    private final boolean terminateOnVisitorException;
    private static final DefaultDOMSerializerVisitor defaultSerializer = new DefaultDOMSerializerVisitor();

    public Serializer(Node node, ExecutionContext executionContext) {
        if (node == null) {
            throw new IllegalArgumentException("null 'node' arg passed in method call.");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in method call.");
        }
        this.node = node;
        this.executionContext = executionContext;
        this.contentDeliveryRuntime = executionContext.getContentDeliveryRuntime();
        DOMContentDeliveryConfig deliveryConfig = (DOMContentDeliveryConfig)this.contentDeliveryRuntime.getContentDeliveryConfig();
        this.serializerVisitorIndex = deliveryConfig.getSerializerVisitorIndex();
        this.globalSUs = this.serializerVisitorIndex.get("*", "//");
        Registry registry = executionContext.getApplicationContext().getRegistry();
        boolean defaultSerializationOn = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("default.serialization.on"));
        if (defaultSerializationOn) {
            this.defaultSerializationUnit = new DefaultDOMSerializerVisitor();
            boolean rewriteEntities = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("entities.rewrite"));
            this.defaultSerializationUnit.setRewriteEntities(Optional.of(rewriteEntities));
            this.defaultSerializationUnit.postConstruct();
        }
        this.terminateOnVisitorException = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("terminate.on.visitor.exception"));
    }

    public void serialize(Writer writer) throws IOException {
        if (writer == null) {
            throw new SmooksException("null 'writer' arg passed in method call.");
        }
        Registry registry = this.executionContext.getApplicationContext().getRegistry();
        LifecycleManager lifecycleManager = (LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup());
        SerializationStartedDOMFilterLifecyclePhase serializationStartedDOMFilterLifecyclePhase = new SerializationStartedDOMFilterLifecyclePhase(this.executionContext);
        for (DOMFilterLifecycle domFilterLifecycle : ((Map)registry.lookup(new InstanceLookup<DOMFilterLifecycle>(DOMFilterLifecycle.class))).values()) {
            lifecycleManager.applyPhase((Object)domFilterLifecycle, (LifecyclePhase)serializationStartedDOMFilterLifecyclePhase);
        }
        if (this.node instanceof Document) {
            Document doc = (Document)this.node;
            Element rootElement = doc.getDocumentElement();
            DocType.DocumentTypeData docTypeData = DocType.getDocType(this.executionContext);
            if (docTypeData != null) {
                DocType.serializeDoctype(docTypeData, writer);
                if (docTypeData.getXmlns() != null) {
                    rootElement.setAttribute("xmlns", docTypeData.getXmlns());
                } else {
                    rootElement.removeAttribute("xmlns");
                }
            }
            this.recursiveDOMWrite(rootElement, writer, true);
        } else {
            NodeList deliveryNodes = this.node.getChildNodes();
            int nodeCount = deliveryNodes.getLength();
            boolean isRoot = this.node == this.node.getOwnerDocument().getDocumentElement();
            for (int i = 0; i < nodeCount; ++i) {
                Node childNode = deliveryNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                this.recursiveDOMWrite((Element)childNode, writer, isRoot);
            }
        }
    }

    private void recursiveDOMWrite(Element element, Writer writer, boolean isRoot) {
        NodeList children = element.getChildNodes();
        SerializerVisitor elementSU = this.getSerializationUnit(element, isRoot);
        try {
            if (elementSU != null) {
                elementSU.writeStartElement(element, writer, this.executionContext);
            }
            if (children != null && children.getLength() > 0) {
                int childCount = children.getLength();
                for (int i = 0; i < childCount; ++i) {
                    Node childNode = children.item(i);
                    if (elementSU != null) {
                        if (childNode.getNodeType() == 1) {
                            if (!elementSU.writeChildElements()) continue;
                            this.recursiveDOMWrite((Element)childNode, writer, false);
                            continue;
                        }
                        elementSU.writeCharacterData(childNode, writer, this.executionContext);
                        continue;
                    }
                    if (childNode.getNodeType() != 1) continue;
                    this.recursiveDOMWrite((Element)childNode, writer, false);
                }
            }
            if (elementSU != null) {
                elementSU.writeEndElement(element, writer, this.executionContext);
            }
        }
        catch (Throwable thrown) {
            String error = "Failed to apply serialization unit [" + elementSU.getClass().getName() + "] to [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
            if (this.terminateOnVisitorException) {
                if (thrown instanceof SmooksException) {
                    throw (SmooksException)thrown;
                }
                throw new SmooksException(error, thrown);
            }
            LOGGER.debug(error, thrown);
        }
    }

    private SerializerVisitor getSerializationUnit(Element element, boolean isRoot) {
        String elementName = DomUtils.getName(element);
        NodeFragment nodeFragment = new NodeFragment(element);
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent(new StartFragmentExecutionEvent<Node>(nodeFragment));
        }
        List<ContentHandlerBinding<SerializerVisitor>> serializerVisitorBindings = isRoot ? this.serializerVisitorIndex.get("#document", elementName) : this.serializerVisitorIndex.get((Object)elementName);
        if (serializerVisitorBindings == null || serializerVisitorBindings.isEmpty()) {
            serializerVisitorBindings = this.globalSUs;
        }
        if (serializerVisitorBindings != null) {
            for (ContentHandlerBinding contentHandlerBinding : serializerVisitorBindings) {
                ResourceConfig resourceConfig = contentHandlerBinding.getResourceConfig();
                if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), this.executionContext)) continue;
                for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent(new ResourceTargetingExecutionEvent<Node>(nodeFragment, resourceConfig, new Object[0]));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Applying serialisation resource [" + resourceConfig + "] to element [" + DomUtils.getXPath(element) + "].");
                }
                return (SerializerVisitor)contentHandlerBinding.getContentHandler();
            }
        }
        return this.defaultSerializationUnit;
    }

    public static void recursiveDOMWrite(Element element, Writer writer) {
        NodeList children = element.getChildNodes();
        try {
            defaultSerializer.writeStartElement(element, writer, null);
            if (children != null && children.getLength() > 0) {
                int childCount = children.getLength();
                for (int i = 0; i < childCount; ++i) {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() == 1) {
                        Serializer.recursiveDOMWrite((Element)childNode, writer);
                        continue;
                    }
                    defaultSerializer.writeCharacterData(childNode, writer, null);
                }
            }
            defaultSerializer.writeEndElement(element, writer, null);
        }
        catch (Throwable thrown) {
            if (thrown instanceof SmooksException) {
                throw (SmooksException)thrown;
            }
            throw new SmooksException("Serailization Error.", thrown);
        }
    }

    static {
        defaultSerializer.setCloseEmptyElements(Optional.of(true));
        defaultSerializer.postConstruct();
    }
}

