/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.dom;

import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.resource.visitor.dom.DOMSerializerVisitor;
import org.smooks.support.DomUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public class ContextObjectSerializerVisitor
implements DOMSerializerVisitor,
ElementVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextObjectSerializerVisitor.class);

    public void writeStartElement(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        String key = ContextObjectSerializerVisitor.getContextKey(element);
        if (key != null) {
            Object object = executionContext.get(TypedKey.of((String)key));
            if (object != null) {
                writer.write(object.toString());
            } else {
                LOGGER.debug("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. No Object instance found on context at '" + key + "'.");
            }
        } else {
            LOGGER.warn("Invalid <context-object> specification at '" + DomUtils.getXPath(element) + "'. 'key' attribute not specified.");
        }
    }

    public static String getContextKey(Element element) {
        return DomUtils.getAttributeValue(element, "key");
    }

    public void writeEndElement(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeCharacterData(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
    }

    public boolean writeChildElements() {
        return false;
    }

    public static Element createElement(Document ownerDocument, String key) {
        Element resultElement = ownerDocument.createElementNS("https://www.smooks.org", "context-object");
        Comment comment = ownerDocument.createComment(" The actual message payload is set on the associated Smooks ExecutionContext under the key '" + key + "'.  Alternatively, you can use Smooks to serialize the message. ");
        resultElement.setAttribute("key", key);
        resultElement.appendChild(comment);
        return resultElement;
    }

    public static boolean isContextObjectElement(Element element) {
        return DomUtils.getName(element).equals("context-object") && "https://www.smooks.org".equals(element.getNamespaceURI());
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) throws SmooksException {
    }
}

