/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.reader;

import com.thoughtworks.xstream.io.xml.SaxWriter;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.resource.reader.JavaXMLReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XStreamXMLReader
implements JavaXMLReader {
    @Inject
    private Boolean includeEnclosingDocument = true;
    private SaxWriter xstreamReader;

    @PostConstruct
    public void postConstruct() {
        this.xstreamReader = new SaxWriter(this.includeEnclosingDocument.booleanValue());
    }

    public void setSourceObjects(List<Object> sourceObjects) throws SmooksConfigException {
        try {
            this.xstreamReader.setProperty("http://com.thoughtworks.xstream/sax/property/source-object-list", sourceObjects);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new SmooksConfigException("Unable to set source Java Objects on the underlying XStream SaxWriter.", (Throwable)e);
        }
    }

    public void setExecutionContext(ExecutionContext executionContext) {
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xstreamReader.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://www.smooks.org/sax/features/generate-java-event-stream")) {
            return;
        }
        this.xstreamReader.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xstreamReader.getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xstreamReader.setProperty(name, value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xstreamReader.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xstreamReader.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler handler) {
        this.xstreamReader.setDTDHandler(handler);
    }

    public DTDHandler getDTDHandler() {
        return this.xstreamReader.getDTDHandler();
    }

    public void setContentHandler(ContentHandler handler) {
        this.xstreamReader.setContentHandler(handler);
    }

    public ContentHandler getContentHandler() {
        return this.xstreamReader.getContentHandler();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.xstreamReader.setErrorHandler(handler);
    }

    public ErrorHandler getErrorHandler() {
        return this.xstreamReader.getErrorHandler();
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.xstreamReader.parse(input);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.xstreamReader.parse(systemId);
    }
}

