/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.resource.config.xpath.SelectorPathJaxenHandler;

public final class SelectorPathFactory {
    private SelectorPathFactory() {
    }

    public static SelectorPath newSelectorPath(String selector) {
        return SelectorPathFactory.newSelectorPath(selector, new Properties());
    }

    public static SelectorPath newSelectorPath(SelectorPath selectorPath) {
        return SelectorPathFactory.newSelectorPath(selectorPath.getSelector(), selectorPath.getNamespaces(), selectorPath.getConditionEvaluator());
    }

    public static SelectorPath newSelectorPath(String selector, Properties namespaces, ExpressionEvaluator conditionEvaluator) {
        SelectorPath newSelectorPath = SelectorPathFactory.newSelectorPath(selector, namespaces);
        newSelectorPath.setConditionEvaluator(conditionEvaluator);
        return newSelectorPath;
    }

    public static SelectorPath newSelectorPath(String selector, Properties namespaces) {
        AssertArgument.isNotEmpty((String)selector, (String)"selector");
        int docSelectorIndex = selector.trim().indexOf("#document");
        if (docSelectorIndex > 0) {
            throw new SmooksConfigException("Invalid selector '" + selector + "'.  '" + "#document" + "' token can only exist at the start of the selector.");
        }
        SelectorPath selectorPath = SelectorPathFactory.buildSelectorPath(selector, namespaces);
        if (namespaces != null) {
            selectorPath.setNamespaces(namespaces);
        }
        return selectorPath;
    }

    private static SelectorPath buildSelectorPath(String selector, Properties namespaces) {
        XPathReader reader;
        AssertArgument.isNotNull((Object)selector, (String)"selector");
        String xpathExpression = selector.replaceAll("#document", "/*");
        try {
            reader = XPathReaderFactory.createReader();
        }
        catch (SAXPathException e) {
            throw new SmooksException((Throwable)e);
        }
        try {
            reader.parse(xpathExpression);
        }
        catch (SAXPathException e) {
            if (selector.split(",").length > 1) {
                return new CompositeSelectorPath(selector, namespaces);
            }
            throw new SmooksException((Throwable)e);
        }
        SelectorPathJaxenHandler xpathHandler = new SelectorPathJaxenHandler(xpathExpression, namespaces);
        if (!xpathExpression.trim().isEmpty()) {
            reader.setXPathHandler((XPathHandler)xpathHandler);
            try {
                reader.parse(xpathExpression);
            }
            catch (SAXPathException e) {
                throw new SmooksException((Throwable)e);
            }
        }
        return xpathHandler.getSelectorPath();
    }

    private static class CompositeSelectorPath
    implements SelectorPath {
        private final String selector;
        private Properties namespaces;

        public CompositeSelectorPath(String selector, Properties namespaces) {
            this.selector = selector;
            this.namespaces = namespaces;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
        }

        public ExpressionEvaluator getConditionEvaluator() {
            return null;
        }

        public Properties getNamespaces() {
            return this.namespaces;
        }

        public void setNamespaces(Properties namespaces) {
            this.namespaces = namespaces;
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        public Iterator<SelectorStep> iterator() {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        public boolean add(SelectorStep selectorStep) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection<? extends SelectorStep> c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection<? extends SelectorStep> c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public SelectorStep get(int index) {
            throw new UnsupportedOperationException();
        }

        public SelectorStep set(int index, SelectorStep element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, SelectorStep element) {
            throw new UnsupportedOperationException();
        }

        public SelectorStep remove(int index) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        public ListIterator<SelectorStep> listIterator() {
            throw new UnsupportedOperationException();
        }

        public ListIterator<SelectorStep> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        public List<SelectorStep> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

