/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.EmptyStackException;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.engine.resource.config.loader.xml.extension.ResourceConfigUtils;
import org.smooks.support.DomUtils;
import org.smooks.support.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapToResourceConfigFromXml
implements DOMVisitBefore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapToResourceConfigFromXml.class);
    @Inject
    private Optional<String> mapTo;
    @Inject
    private Optional<String> mapToSpecifier;
    @Inject
    private Optional<String> defaultValue;

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ResourceConfig config;
        String value = XmlUtils.serialize((NodeList)((NodeList)((Object)element)), (boolean)true);
        String mapToPropertyName = this.mapTo.orElse(null);
        if (mapToPropertyName == null) {
            if (!this.mapToSpecifier.isPresent()) {
                throw new SmooksException("One of attributes 'mapTo' or 'mapToSpecifier' must be specified.");
            }
            mapToPropertyName = DomUtils.getAttributeValue(element, this.mapToSpecifier.get());
        }
        try {
            config = ((ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY)).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No ResourceConfig available in ExtensionContext stack.  Unable to set ResourceConfig property '" + mapToPropertyName + "' with element text value.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting property '" + mapToPropertyName + "' on resource configuration to a value of '" + value + "'.");
        }
        ResourceConfigUtils.setProperty(config, mapToPropertyName, value, element, executionContext);
    }
}

