/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.injector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.smooks.api.NotAppContextScoped;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.injector.Injector;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;
import org.smooks.support.ClassUtils;

public abstract class AbstractInjector<M extends Member>
implements Injector {
    protected void setMember(M member, Object instance, Object value, String name) {
        try {
            if (value instanceof NotAppContextScoped.Ref) {
                this.doSetMember((Member)member, instance, ((NotAppContextScoped.Ref)value).get(), name);
            } else {
                this.doSetMember((Member)member, instance, value, name);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SmooksConfigException(String.format("Failed to set parameter configuration value on [%s]", ClassUtils.getLongMemberName(member)), (Throwable)e);
        }
    }

    protected TypeConverter<?, ?> createTypeConverter(Class<?> sourceType, M member, Registry registry) {
        Type actualType;
        Class<?> targetType = this.getType(member);
        TypeConverterFactory typeConverterFactory = targetType.equals(Optional.class) ? ((actualType = this.getActualType(member)) instanceof Class ? (TypeConverterFactory)registry.lookup(new SourceTargetTypeConverterFactoryLookup(sourceType, (Class)actualType)) : (TypeConverterFactory)registry.lookup(new SourceTargetTypeConverterFactoryLookup(sourceType, (Class)((ParameterizedType)actualType).getRawType()))) : (TypeConverterFactory)registry.lookup(new SourceTargetTypeConverterFactoryLookup(sourceType, targetType));
        TypeConverter typeConverter = typeConverterFactory != null ? typeConverterFactory.createTypeConverter() : ((TypeConverterFactory)registry.lookup(new SourceTargetTypeConverterFactoryLookup<Object, Object>(Object.class, Object.class))).createTypeConverter();
        return typeConverter;
    }

    protected boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    protected void inject(Named namedAnnotation, M member, Object instance, Scope scope) throws SmooksConfigException {
        String name = this.getName(namedAnnotation, member);
        Object valueInject = scope.get(name);
        Type realType = this.getRealType(member);
        if (valueInject == null) {
            valueInject = scope.get(realType);
        }
        if (valueInject != null) {
            try {
                TypeConverter<?, ?> typeConverter = this.createTypeConverter(valueInject.getClass(), member, scope.getRegistry());
                ((LifecycleManager)scope.getRegistry().lookup((Function)new LifecycleManagerLookup())).applyPhase(typeConverter, (LifecyclePhase)new PostConstructLifecyclePhase(scope));
                Object convertedValueInject = typeConverter.convert(valueInject);
                if (this.isEnum(realType)) {
                    try {
                        convertedValueInject = Enum.valueOf((Class)realType, convertedValueInject.toString());
                    }
                    catch (IllegalArgumentException e) {
                        T[] enumConstants = ((Class)realType).getEnumConstants();
                        throw new SmooksConfigException(String.format("Value [%s] for parameter [%s] is invalid. Valid choices for this parameter are: %s", convertedValueInject, name, Arrays.stream(enumConstants).map(c -> ((Enum)c).name()).collect(Collectors.toList())));
                    }
                }
                if (this.getType(member).equals(Optional.class) && !(valueInject instanceof Optional)) {
                    this.setMember(member, instance, Optional.of(convertedValueInject), name);
                }
                this.setMember(member, instance, convertedValueInject, name);
            }
            catch (TypeConverterException e) {
                throw new SmooksConfigException(String.format("Failed to set parameter configuration value on [%s]", ClassUtils.getLongMemberName(member)), (Throwable)e);
            }
        } else if (this.getDefaultParamValue(instance, member) == null) {
            if (this.getType(member).equals(Optional.class)) {
                this.setMember(member, instance, Optional.empty(), name);
            } else {
                throw new SmooksConfigException(String.format("Parameter [%s] not specified on resource configuration:%s", name, System.lineSeparator() + scope));
            }
        }
    }

    protected abstract Class<?> getType(M var1);

    protected abstract Type getActualType(M var1);

    protected abstract String getName(Named var1, M var2);

    protected abstract Object getDefaultParamValue(Object var1, M var2);

    protected abstract void doSetMember(Member var1, Object var2, Object var3, String var4) throws InvocationTargetException, IllegalAccessException;

    protected Type getRealType(M member) {
        Class<?> type = this.getType(member);
        if (this.getType(member).equals(Optional.class)) {
            return this.getActualType(member);
        }
        return type;
    }
}

