/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.EncodingMap;

public class EncodingInfo {
    private Object[] fArgsForMethod = null;
    String ianaName;
    String javaName;
    int lastPrintable;
    Object fCharsetEncoder = null;
    Object fCharToByteConverter = null;
    boolean fHaveTriedCToB = false;
    boolean fHaveTriedCharsetEncoder = false;

    public EncodingInfo(String ianaName, String javaName, int lastPrintable) {
        this.ianaName = ianaName;
        this.javaName = EncodingMap.getIANA2JavaMapping(ianaName);
        this.lastPrintable = lastPrintable;
    }

    public String getIANAName() {
        return this.ianaName;
    }

    public Writer getWriter(OutputStream output) throws UnsupportedEncodingException {
        if (this.javaName != null) {
            return new OutputStreamWriter(output, this.javaName);
        }
        this.javaName = EncodingMap.getIANA2JavaMapping(this.ianaName);
        if (this.javaName == null) {
            return new OutputStreamWriter(output, "UTF8");
        }
        return new OutputStreamWriter(output, this.javaName);
    }

    public boolean isPrintable(char ch) {
        if (ch <= this.lastPrintable) {
            return true;
        }
        return this.isPrintable0(ch);
    }

    private boolean isPrintable0(char ch) {
        if (this.fCharsetEncoder == null && CharsetMethods.fgNIOCharsetAvailable && !this.fHaveTriedCharsetEncoder) {
            if (this.fArgsForMethod == null) {
                this.fArgsForMethod = new Object[1];
            }
            try {
                this.fArgsForMethod[0] = this.javaName;
                Object charset = CharsetMethods.fgCharsetForNameMethod.invoke(null, this.fArgsForMethod);
                if (((Boolean)CharsetMethods.fgCharsetCanEncodeMethod.invoke(charset, (Object[])null)).booleanValue()) {
                    this.fCharsetEncoder = CharsetMethods.fgCharsetNewEncoderMethod.invoke(charset, (Object[])null);
                } else {
                    this.fHaveTriedCharsetEncoder = true;
                }
            }
            catch (Exception e) {
                this.fHaveTriedCharsetEncoder = true;
            }
        }
        if (this.fCharsetEncoder != null) {
            try {
                this.fArgsForMethod[0] = new Character(ch);
                return (Boolean)CharsetMethods.fgCharsetEncoderCanEncodeMethod.invoke(this.fCharsetEncoder, this.fArgsForMethod);
            }
            catch (Exception e) {
                this.fCharsetEncoder = null;
                this.fHaveTriedCharsetEncoder = false;
            }
        }
        if (this.fCharToByteConverter == null) {
            if (this.fHaveTriedCToB || !CharToByteConverterMethods.fgConvertersAvailable) {
                return false;
            }
            if (this.fArgsForMethod == null) {
                this.fArgsForMethod = new Object[1];
            }
            try {
                this.fArgsForMethod[0] = this.javaName;
                this.fCharToByteConverter = CharToByteConverterMethods.fgGetConverterMethod.invoke(null, this.fArgsForMethod);
            }
            catch (Exception e) {
                this.fHaveTriedCToB = true;
                return false;
            }
        }
        try {
            this.fArgsForMethod[0] = new Character(ch);
            return (Boolean)CharToByteConverterMethods.fgCanConvertMethod.invoke(this.fCharToByteConverter, this.fArgsForMethod);
        }
        catch (Exception e) {
            this.fCharToByteConverter = null;
            this.fHaveTriedCToB = false;
            return false;
        }
    }

    public static void testJavaEncodingName(String name) throws UnsupportedEncodingException {
        byte[] bTest = new byte[]{118, 97, 108, 105, 100};
        String s = new String(bTest, name);
    }

    static class CharToByteConverterMethods {
        private static Method fgGetConverterMethod = null;
        private static Method fgCanConvertMethod = null;
        private static boolean fgConvertersAvailable = false;

        private CharToByteConverterMethods() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("sun.io.CharToByteConverter");
                fgGetConverterMethod = clazz.getMethod("getConverter", String.class);
                fgCanConvertMethod = clazz.getMethod("canConvert", Character.TYPE);
                fgConvertersAvailable = true;
            }
            catch (Exception exc) {
                fgGetConverterMethod = null;
                fgCanConvertMethod = null;
                fgConvertersAvailable = false;
            }
        }
    }

    static class CharsetMethods {
        private static Method fgCharsetForNameMethod = null;
        private static Method fgCharsetCanEncodeMethod = null;
        private static Method fgCharsetNewEncoderMethod = null;
        private static Method fgCharsetEncoderCanEncodeMethod = null;
        private static boolean fgNIOCharsetAvailable = false;

        private CharsetMethods() {
        }

        static {
            try {
                Class<?> charsetClass = Class.forName("java.nio.charset.Charset");
                Class<?> charsetEncoderClass = Class.forName("java.nio.charset.CharsetEncoder");
                fgCharsetForNameMethod = charsetClass.getMethod("forName", String.class);
                fgCharsetCanEncodeMethod = charsetClass.getMethod("canEncode", new Class[0]);
                fgCharsetNewEncoderMethod = charsetClass.getMethod("newEncoder", new Class[0]);
                fgCharsetEncoderCanEncodeMethod = charsetEncoderClass.getMethod("canEncode", Character.TYPE);
                fgNIOCharsetAvailable = true;
            }
            catch (Exception exc) {
                fgCharsetForNameMethod = null;
                fgCharsetCanEncodeMethod = null;
                fgCharsetEncoderCanEncodeMethod = null;
                fgCharsetNewEncoderMethod = null;
                fgNIOCharsetAvailable = false;
            }
        }
    }
}

