/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.xs.traversers;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.JAXPNamespaceContextWrapper;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.StAXLocationWrapper;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.SymbolTable;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLAttributesImpl;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLStringBuffer;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.util.XMLSymbols;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.NamespaceContext;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.XMLString;
import org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.XNIException;
import org.w3c.dom.Document;

final class StAXSchemaParser {
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private final char[] fCharBuffer = new char[1024];
    private SymbolTable fSymbolTable = new SymbolTable();
    private SchemaDOMParser fSchemaDOMParser;
    private final StAXLocationWrapper fLocationWrapper = new StAXLocationWrapper();
    private final JAXPNamespaceContextWrapper fNamespaceContext = new JAXPNamespaceContextWrapper(this.fSymbolTable);
    private final org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName fElementQName = new org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName();
    private final org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName fAttributeQName = new org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName();
    private final XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    private final XMLString fTempString = new XMLString();
    private final ArrayList fDeclaredPrefixes = new ArrayList();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private int fDepth;

    public StAXSchemaParser() {
        this.fNamespaceContext.setDeclaredPrefixes(this.fDeclaredPrefixes);
    }

    public void reset(SchemaDOMParser schemaDOMParser, SymbolTable symbolTable) {
        this.fSchemaDOMParser = schemaDOMParser;
        this.fSymbolTable = symbolTable;
        this.fNamespaceContext.setSymbolTable(this.fSymbolTable);
        this.fNamespaceContext.reset();
    }

    public Document getDocument() {
        return this.fSchemaDOMParser.getDocument();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(XMLEventReader input) throws XMLStreamException, XNIException {
        XMLEvent currentEvent = input.peek();
        if (currentEvent != null) {
            int eventType = currentEvent.getEventType();
            if (eventType != 7 && eventType != 1) {
                throw new XMLStreamException();
            }
            this.fLocationWrapper.setLocation(currentEvent.getLocation());
            this.fSchemaDOMParser.startDocument(this.fLocationWrapper, null, this.fNamespaceContext, null);
            block12: while (input.hasNext()) {
                currentEvent = input.nextEvent();
                eventType = currentEvent.getEventType();
                switch (eventType) {
                    case 1: {
                        ++this.fDepth;
                        StartElement start = currentEvent.asStartElement();
                        this.fillQName(this.fElementQName, start.getName());
                        this.fLocationWrapper.setLocation(start.getLocation());
                        this.fNamespaceContext.setNamespaceContext(start.getNamespaceContext());
                        this.fillXMLAttributes(start);
                        this.fillDeclaredPrefixes(start);
                        this.addNamespaceDeclarations();
                        this.fNamespaceContext.pushContext();
                        this.fSchemaDOMParser.startElement(this.fElementQName, this.fAttributes, null);
                        break;
                    }
                    case 2: {
                        EndElement end = currentEvent.asEndElement();
                        this.fillQName(this.fElementQName, end.getName());
                        this.fillDeclaredPrefixes(end);
                        this.fLocationWrapper.setLocation(end.getLocation());
                        this.fSchemaDOMParser.endElement(this.fElementQName, null);
                        this.fNamespaceContext.popContext();
                        --this.fDepth;
                        if (this.fDepth > 0) break;
                        break block12;
                    }
                    case 4: {
                        this.sendCharactersToSchemaParser(currentEvent.asCharacters().getData(), false);
                        break;
                    }
                    case 6: {
                        this.sendCharactersToSchemaParser(currentEvent.asCharacters().getData(), true);
                        break;
                    }
                    case 12: {
                        this.fSchemaDOMParser.startCDATA(null);
                        this.sendCharactersToSchemaParser(currentEvent.asCharacters().getData(), false);
                        this.fSchemaDOMParser.endCDATA(null);
                        break;
                    }
                    case 3: {
                        ProcessingInstruction pi = (ProcessingInstruction)currentEvent;
                        this.fillProcessingInstruction(pi.getData());
                        this.fSchemaDOMParser.processingInstruction(pi.getTarget(), this.fTempString, null);
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        ++this.fDepth;
                    }
                }
            }
            this.fLocationWrapper.setLocation(null);
            this.fNamespaceContext.setNamespaceContext(null);
            this.fSchemaDOMParser.endDocument(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(XMLStreamReader input) throws XMLStreamException, XNIException {
        if (input.hasNext()) {
            int eventType = input.getEventType();
            if (eventType != 7 && eventType != 1) {
                throw new XMLStreamException();
            }
            this.fLocationWrapper.setLocation(input.getLocation());
            this.fSchemaDOMParser.startDocument(this.fLocationWrapper, null, this.fNamespaceContext, null);
            boolean first = true;
            block12: while (input.hasNext()) {
                if (!first) {
                    eventType = input.next();
                } else {
                    first = false;
                }
                switch (eventType) {
                    case 1: {
                        ++this.fDepth;
                        this.fLocationWrapper.setLocation(input.getLocation());
                        this.fNamespaceContext.setNamespaceContext(input.getNamespaceContext());
                        this.fillQName(this.fElementQName, input.getNamespaceURI(), input.getLocalName(), input.getPrefix());
                        this.fillXMLAttributes(input);
                        this.fillDeclaredPrefixes(input);
                        this.addNamespaceDeclarations();
                        this.fNamespaceContext.pushContext();
                        this.fSchemaDOMParser.startElement(this.fElementQName, this.fAttributes, null);
                        break;
                    }
                    case 2: {
                        this.fLocationWrapper.setLocation(input.getLocation());
                        this.fNamespaceContext.setNamespaceContext(input.getNamespaceContext());
                        this.fillQName(this.fElementQName, input.getNamespaceURI(), input.getLocalName(), input.getPrefix());
                        this.fillDeclaredPrefixes(input);
                        this.fSchemaDOMParser.endElement(this.fElementQName, null);
                        this.fNamespaceContext.popContext();
                        --this.fDepth;
                        if (this.fDepth > 0) break;
                        break block12;
                    }
                    case 4: {
                        this.fTempString.setValues(input.getTextCharacters(), input.getTextStart(), input.getTextLength());
                        this.fSchemaDOMParser.characters(this.fTempString, null);
                        break;
                    }
                    case 6: {
                        this.fTempString.setValues(input.getTextCharacters(), input.getTextStart(), input.getTextLength());
                        this.fSchemaDOMParser.ignorableWhitespace(this.fTempString, null);
                        break;
                    }
                    case 12: {
                        this.fSchemaDOMParser.startCDATA(null);
                        this.fTempString.setValues(input.getTextCharacters(), input.getTextStart(), input.getTextLength());
                        this.fSchemaDOMParser.characters(this.fTempString, null);
                        this.fSchemaDOMParser.endCDATA(null);
                        break;
                    }
                    case 3: {
                        this.fillProcessingInstruction(input.getPIData());
                        this.fSchemaDOMParser.processingInstruction(input.getPITarget(), this.fTempString, null);
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 7: {
                        ++this.fDepth;
                    }
                }
            }
            this.fLocationWrapper.setLocation(null);
            this.fNamespaceContext.setNamespaceContext(null);
            this.fSchemaDOMParser.endDocument(null);
        }
    }

    private void sendCharactersToSchemaParser(String str, boolean whitespace) {
        if (str != null) {
            int length = str.length();
            int remainder = length & 0x3FF;
            if (remainder > 0) {
                str.getChars(0, remainder, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, remainder);
                if (whitespace) {
                    this.fSchemaDOMParser.ignorableWhitespace(this.fTempString, null);
                } else {
                    this.fSchemaDOMParser.characters(this.fTempString, null);
                }
            }
            int i = remainder;
            while (i < length) {
                str.getChars(i, i += 1024, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, 1024);
                if (whitespace) {
                    this.fSchemaDOMParser.ignorableWhitespace(this.fTempString, null);
                    continue;
                }
                this.fSchemaDOMParser.characters(this.fTempString, null);
            }
        }
    }

    private void fillProcessingInstruction(String data) {
        char[] charBuffer = this.fCharBuffer;
        int dataLength = data.length();
        if (charBuffer.length < dataLength) {
            charBuffer = data.toCharArray();
        } else {
            data.getChars(0, dataLength, charBuffer, 0);
        }
        this.fTempString.setValues(charBuffer, 0, dataLength);
    }

    private void fillXMLAttributes(StartElement event) {
        this.fAttributes.removeAllAttributes();
        Iterator<Attribute> attrs = event.getAttributes();
        while (attrs.hasNext()) {
            Attribute attr = attrs.next();
            this.fillQName(this.fAttributeQName, attr.getName());
            String type = attr.getDTDType();
            int idx = this.fAttributes.getLength();
            this.fAttributes.addAttributeNS(this.fAttributeQName, type != null ? type : XMLSymbols.fCDATASymbol, attr.getValue());
            this.fAttributes.setSpecified(idx, attr.isSpecified());
        }
    }

    private void fillXMLAttributes(XMLStreamReader input) {
        this.fAttributes.removeAllAttributes();
        int len = input.getAttributeCount();
        for (int i = 0; i < len; ++i) {
            this.fillQName(this.fAttributeQName, input.getAttributeNamespace(i), input.getAttributeLocalName(i), input.getAttributePrefix(i));
            String type = input.getAttributeType(i);
            this.fAttributes.addAttributeNS(this.fAttributeQName, type != null ? type : XMLSymbols.fCDATASymbol, input.getAttributeValue(i));
            this.fAttributes.setSpecified(i, input.isAttributeSpecified(i));
        }
    }

    private void addNamespaceDeclarations() {
        String prefix = null;
        String localpart = null;
        String rawname = null;
        String nsPrefix2 = null;
        String nsURI = null;
        for (String nsPrefix2 : this.fDeclaredPrefixes) {
            nsURI = this.fNamespaceContext.getURI(nsPrefix2);
            if (nsPrefix2.length() > 0) {
                prefix = XMLSymbols.PREFIX_XMLNS;
                localpart = nsPrefix2;
                this.fStringBuffer.clear();
                this.fStringBuffer.append(prefix);
                this.fStringBuffer.append(':');
                this.fStringBuffer.append(localpart);
                rawname = this.fSymbolTable.addSymbol(this.fStringBuffer.ch, this.fStringBuffer.offset, this.fStringBuffer.length);
            } else {
                prefix = XMLSymbols.EMPTY_STRING;
                localpart = XMLSymbols.PREFIX_XMLNS;
                rawname = XMLSymbols.PREFIX_XMLNS;
            }
            this.fAttributeQName.setValues(prefix, localpart, rawname, NamespaceContext.XMLNS_URI);
            this.fAttributes.addAttribute(this.fAttributeQName, XMLSymbols.fCDATASymbol, nsURI != null ? nsURI : XMLSymbols.EMPTY_STRING);
        }
    }

    private void fillDeclaredPrefixes(StartElement event) {
        this.fillDeclaredPrefixes(event.getNamespaces());
    }

    private void fillDeclaredPrefixes(EndElement event) {
        this.fillDeclaredPrefixes(event.getNamespaces());
    }

    private void fillDeclaredPrefixes(Iterator namespaces) {
        this.fDeclaredPrefixes.clear();
        while (namespaces.hasNext()) {
            Namespace ns = (Namespace)namespaces.next();
            String prefix = ns.getPrefix();
            this.fDeclaredPrefixes.add(prefix != null ? prefix : "");
        }
    }

    private void fillDeclaredPrefixes(XMLStreamReader reader) {
        this.fDeclaredPrefixes.clear();
        int len = reader.getNamespaceCount();
        for (int i = 0; i < len; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            this.fDeclaredPrefixes.add(prefix != null ? prefix : "");
        }
    }

    private void fillQName(org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName toFill, QName toCopy) {
        this.fillQName(toFill, toCopy.getNamespaceURI(), toCopy.getLocalPart(), toCopy.getPrefix());
    }

    final void fillQName(org.smooks.engine.delivery.sax.ng.org.apache.xerces.xni.QName toFill, String uri, String localpart, String prefix) {
        uri = uri != null && uri.length() > 0 ? this.fSymbolTable.addSymbol(uri) : null;
        localpart = localpart != null ? this.fSymbolTable.addSymbol(localpart) : XMLSymbols.EMPTY_STRING;
        prefix = prefix != null && prefix.length() > 0 ? this.fSymbolTable.addSymbol(prefix) : XMLSymbols.EMPTY_STRING;
        String raw = localpart;
        if (prefix != XMLSymbols.EMPTY_STRING) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append(prefix);
            this.fStringBuffer.append(':');
            this.fStringBuffer.append(localpart);
            raw = this.fSymbolTable.addSymbol(this.fStringBuffer.ch, this.fStringBuffer.offset, this.fStringBuffer.length);
        }
        toFill.setValues(prefix, localpart, raw, uri);
    }
}

