/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.xpath.Predicate;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.engine.delivery.AbstractFilterProvider;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.event.DefaultContentDeliveryConfigExecutionEvent;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorChainFactory;
import org.smooks.engine.delivery.sax.ng.SaxNgContentDeliveryConfig;
import org.smooks.engine.lookup.InterceptorVisitorChainFactoryLookup;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.config.xpath.ElementPositionCounter;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.predicate.PositionPredicateEvaluator;
import org.smooks.engine.resource.config.xpath.step.DocumentSelectorStep;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;
import org.smooks.engine.resource.config.xpath.step.NamedSelectorStep;

public class SaxNgFilterProvider
extends AbstractFilterProvider {
    public SaxNgContentDeliveryConfig createContentDeliveryConfig(List<ContentHandlerBinding<Visitor>> visitorBindings, Registry registry, Map<String, List<ResourceConfig>> resourceConfigTable, List<ContentDeliveryConfigExecutionEvent> contentDeliveryConfigExecutionEvents) {
        SaxNgContentDeliveryConfig saxNgContentDeliveryConfig = new SaxNgContentDeliveryConfig();
        InterceptorVisitorChainFactory interceptorVisitorChainFactory = (InterceptorVisitorChainFactory)registry.lookup((Function)new InterceptorVisitorChainFactoryLookup());
        for (ContentHandlerBinding<Visitor> visitorBinding : visitorBindings) {
            visitorBinding.getResourceConfig().getSelectorPath().setNamespaces(((Optional)registry.lookup((Function)new NamespaceManagerLookup())).orElse(new Properties()));
            if (!(visitorBinding.getContentHandler() instanceof BeforeVisitor) && !(visitorBinding.getContentHandler() instanceof AfterVisitor)) continue;
            if (visitorBinding.getContentHandler() instanceof BeforeVisitor || visitorBinding.getContentHandler() instanceof ChildrenVisitor) {
                this.assertSelectorsNotAccessingText(visitorBinding.getResourceConfig());
            }
            ContentHandlerBinding<Visitor> interceptorChain = interceptorVisitorChainFactory.createInterceptorChain(visitorBinding);
            Visitor interceptorChainVisitor = (Visitor)interceptorChain.getContentHandler();
            String selector = null;
            if (interceptorChain.getResourceConfig().getSelectorPath() instanceof IndexedSelectorPath) {
                for (int i = interceptorChain.getResourceConfig().getSelectorPath().size(); i > 0; --i) {
                    SelectorStep selectorStep = (SelectorStep)interceptorChain.getResourceConfig().getSelectorPath().get(i - 1);
                    if (!(selectorStep instanceof ElementSelectorStep)) continue;
                    selector = ((ElementSelectorStep)selectorStep).getQName().getLocalPart();
                    break;
                }
            } else {
                selector = "*";
            }
            if (interceptorChainVisitor instanceof BeforeVisitor && this.visitBeforeAnnotationsOK(visitorBinding.getContentHandler())) {
                saxNgContentDeliveryConfig.getBeforeVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (BeforeVisitor)interceptorChainVisitor);
                if (interceptorChainVisitor instanceof ChildrenVisitor) {
                    saxNgContentDeliveryConfig.getChildVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor)interceptorChainVisitor);
                }
            }
            if (interceptorChainVisitor instanceof AfterVisitor && this.visitAfterAnnotationsOK(visitorBinding.getContentHandler())) {
                saxNgContentDeliveryConfig.getAfterVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (AfterVisitor)interceptorChainVisitor);
                if (!(interceptorChainVisitor instanceof BeforeVisitor) && interceptorChainVisitor instanceof ChildrenVisitor) {
                    saxNgContentDeliveryConfig.getChildVisitorIndex().put(selector, interceptorChain.getResourceConfig(), (ChildrenVisitor)interceptorChainVisitor);
                }
            }
            this.addPositionCounter(interceptorChain, saxNgContentDeliveryConfig);
            contentDeliveryConfigExecutionEvents.add(new DefaultContentDeliveryConfigExecutionEvent(interceptorChain.getResourceConfig(), "Added as a SAX NG visitor."));
        }
        saxNgContentDeliveryConfig.setRegistry(registry);
        saxNgContentDeliveryConfig.setResourceConfigs(resourceConfigTable);
        saxNgContentDeliveryConfig.getContentDeliveryConfigExecutionEvents().addAll(contentDeliveryConfigExecutionEvents);
        saxNgContentDeliveryConfig.addToExecutionLifecycleSets();
        return saxNgContentDeliveryConfig;
    }

    protected <T extends Visitor> void addPositionCounter(ContentHandlerBinding<T> contentHandlerBinding, SaxNgContentDeliveryConfig saxNgContentDeliveryConfig) {
        SelectorPath selectorPath = contentHandlerBinding.getResourceConfig().getSelectorPath();
        for (int i = 0; i < selectorPath.size(); ++i) {
            List selectorSteps = selectorPath.subList(0, i + 1);
            SelectorStep lastSelectorStep = (SelectorStep)selectorSteps.get(selectorSteps.size() - 1);
            if (!(lastSelectorStep instanceof ElementSelectorStep)) continue;
            for (Predicate predicate : lastSelectorStep.getPredicates()) {
                if (!(predicate instanceof PositionPredicateEvaluator)) continue;
                ElementPositionCounter elementPositionCounter = new ElementPositionCounter();
                ((PositionPredicateEvaluator)predicate).setCounter(elementPositionCounter);
                this.addPositionCounter(elementPositionCounter, saxNgContentDeliveryConfig, selectorSteps);
            }
        }
    }

    protected void addPositionCounter(ElementPositionCounter positionCounter, SaxNgContentDeliveryConfig saxNgContentDeliveryConfig, List<SelectorStep> selectorSteps) {
        ElementSelectorStep lastSelectorStep = (ElementSelectorStep)selectorSteps.get(selectorSteps.size() - 1);
        StringBuilder positionCounterSelector = new StringBuilder();
        Properties namespaces = new Properties();
        boolean prepend = false;
        for (SelectorStep selectorStep : selectorSteps) {
            QName qName;
            namespaces.putAll((Map<?, ?>)selectorStep.getNamespaces());
            if (selectorStep instanceof DocumentSelectorStep) {
                positionCounterSelector.append("/");
                continue;
            }
            if (prepend) {
                positionCounterSelector.append("/");
            }
            if (!(qName = ((NamedSelectorStep)selectorStep).getQName()).getPrefix().isEmpty()) {
                positionCounterSelector.append(qName.getPrefix()).append(":");
            }
            positionCounterSelector.append(qName.getLocalPart());
            prepend = true;
        }
        DefaultResourceConfig positionCounterResourceConfig = new DefaultResourceConfig(positionCounterSelector.toString(), namespaces);
        String lastStepNodeName = lastSelectorStep.getQName().getLocalPart();
        saxNgContentDeliveryConfig.getBeforeVisitorIndex().put(lastStepNodeName, (ContentHandlerBinding<BeforeVisitor>)new DefaultContentHandlerBinding<ElementPositionCounter>(positionCounter, positionCounterResourceConfig));
    }

    protected void assertSelectorsNotAccessingText(ResourceConfig resourceConfig) {
        if (resourceConfig.getSelectorPath() instanceof IndexedSelectorPath && ((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep() instanceof ElementSelectorStep && ((ElementSelectorStep)((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep()).accessesText()) {
            throw new SmooksConfigException("Unsupported selector '" + resourceConfig.getSelectorPath().getSelector() + "' on resource '" + resourceConfig + "'.  The 'text()' XPath token is only supported on SAX Visitor implementations that implement the " + AfterVisitor.class.getName() + " interface only.  Class '" + resourceConfig.getResource() + "' implements other SAX Visitor interfaces.");
        }
    }

    public Boolean isProvider(List<ContentHandlerBinding<Visitor>> contentHandlerBindings) {
        return contentHandlerBindings.stream().filter(c -> c.getContentHandler() instanceof BeforeVisitor || c.getContentHandler() instanceof AfterVisitor).count() == (long)contentHandlerBindings.size();
    }

    public String getName() {
        return "SAX NG";
    }
}

