/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.StaticProxyInterceptor;
import org.smooks.engine.delivery.sax.ng.pointer.EventPointer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventPointerStaticProxyInterceptor
extends StaticProxyInterceptor {
    protected boolean doVisit(EventPointer eventPointer, VisitSequence currentVisit, ExecutionContext executionContext) {
        if (eventPointer.getVisit().equals((Object)currentVisit)) {
            Node sourceNode = eventPointer.dereference(executionContext);
            if (sourceNode instanceof CharacterData) {
                return new NodeFragment(sourceNode.getParentNode()).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext);
            }
            return new NodeFragment(sourceNode).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext);
        }
        return false;
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) {
        if (EventPointer.isPointer(element)) {
            EventPointer eventPointer = new EventPointer(element);
            if (this.doVisit(eventPointer, VisitSequence.BEFORE, executionContext)) {
                super.visitBefore((Element)eventPointer.dereference(executionContext), executionContext);
            }
        } else if (new NodeFragment(element).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            super.visitBefore(element, executionContext);
        }
    }

    @Override
    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        if (new NodeFragment(characterData.getParentNode()).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            super.visitChildText(characterData, executionContext);
        }
    }

    @Override
    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        super.visitChildElement(childElement, executionContext);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) {
        if (EventPointer.isPointer(element)) {
            EventPointer eventPointer = new EventPointer(element);
            if (this.doVisit(eventPointer, VisitSequence.CHILD_TEXT, executionContext) || this.doVisit(eventPointer, VisitSequence.AFTER, executionContext)) {
                Node source = eventPointer.dereference(executionContext);
                if (eventPointer.getVisit().equals((Object)VisitSequence.CHILD_TEXT)) {
                    super.visitChildText((CharacterData)source, executionContext);
                } else {
                    super.visitAfter((Element)source, executionContext);
                }
            }
        } else if (new NodeFragment(element).isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) {
            super.visitAfter(element, executionContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onPostFragment(Fragment<?> fragment, ExecutionContext executionContext) {
        NodeFragment fragmentUnderTest;
        Node node = (Node)fragment.unwrap();
        if (EventPointer.isPointer(node)) {
            EventPointer eventPointer = new EventPointer(node);
            if (!eventPointer.getVisit().equals((Object)VisitSequence.AFTER)) return;
            fragmentUnderTest = new NodeFragment(eventPointer.dereference(executionContext));
        } else {
            fragmentUnderTest = fragment;
        }
        if (!fragmentUnderTest.isMatch(this.getTarget().getResourceConfig().getSelectorPath(), executionContext)) return;
        super.onPostFragment(fragmentUnderTest, executionContext);
    }
}

