/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

public class StringToFloatConverterFactory
implements TypeConverterFactory<String, Float>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, Float> createTypeConverter() {
        NumberTypeConverter<String, Float> numberTypeConverter = new NumberTypeConverter<String, Float>(){

            @Override
            protected Float doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        return Float.valueOf(number.floatValue());
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Float value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return Float.valueOf(Float.parseFloat(value.trim()));
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode float value '" + value + "'.", (Throwable)e);
                }
            }
        };
        numberTypeConverter.setConfiguration(this.properties);
        return numberTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<Float>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Float>>(String.class, Float.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }
}

