/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="BigDecimal")
public class StringToBigDecimalConverterFactory
implements TypeConverterFactory<String, BigDecimal>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, BigDecimal> createTypeConverter() {
        NumberTypeConverter<String, BigDecimal> numberTypeConverter = new NumberTypeConverter<String, BigDecimal>(){

            @Override
            protected BigDecimal doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (number instanceof BigDecimal) {
                            return (BigDecimal)number;
                        }
                        if (number instanceof BigInteger) {
                            return new BigDecimal((BigInteger)number);
                        }
                        return BigDecimal.valueOf(number.doubleValue());
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode BigDecimal value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", (Throwable)e);
                    }
                }
                try {
                    return new BigDecimal(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode BigDecimal value '" + value + "'.", (Throwable)e);
                }
            }
        };
        numberTypeConverter.setConfiguration(this.properties);
        return numberTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<BigDecimal>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<BigDecimal>>(String.class, BigDecimal.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }
}

