/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.Date;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.StringToDateLocaleAwareConverter;

public class SqlDateConverterFactory
implements TypeConverterFactory<String, java.sql.Date>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, java.sql.Date> createTypeConverter() {
        SqlDateTypeConverter sqlDateTypeConverter = new SqlDateTypeConverter();
        sqlDateTypeConverter.setConfiguration(this.properties);
        return sqlDateTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<java.sql.Date>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<java.sql.Date>>(String.class, java.sql.Date.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public static class SqlDateTypeConverter
    extends StringToDateLocaleAwareConverter<java.sql.Date> {
        @Override
        protected java.sql.Date doConvert(Date date) {
            return new java.sql.Date(date.getTime());
        }
    }
}

