/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.MappingTypeConverterFactory;
import org.smooks.support.ClassUtils;

@Resource(name="Enum")
public class EnumTypeConverterFactory
implements TypeConverterFactory<String, Enum>,
Configurable {
    private Properties properties = new Properties();

    public TypeConverter<String, Enum> createTypeConverter() {
        EnumTypeConverter enumTypeConverter = new EnumTypeConverter();
        enumTypeConverter.setConfiguration(this.properties);
        return enumTypeConverter;
    }

    public TypeConverterDescriptor<Class<String>, Class<Enum>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Enum>>(String.class, Enum.class);
    }

    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    public Properties getConfiguration() {
        return this.properties;
    }

    public static class EnumTypeConverter
    implements TypeConverter<String, Enum>,
    Configurable {
        private final MappingTypeConverterFactory.MappingTypeConverter mappingTypeConverter = new MappingTypeConverterFactory().createTypeConverter();
        private Properties properties;
        private Class enumType;
        private boolean strict = true;

        public Enum<?> convert(String value) {
            String mappedValue = this.mappingTypeConverter.convert(value);
            try {
                return Enum.valueOf(this.enumType, mappedValue.trim());
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new TypeConverterException("Failed to convert '" + mappedValue + "' as a valid Enum constant of type '" + this.enumType.getName() + "'.");
                }
                return null;
            }
        }

        public void setConfiguration(Properties properties) throws SmooksConfigException {
            this.properties = properties;
            String enumTypeName = properties.getProperty("enumType");
            if (enumTypeName == null || enumTypeName.trim().equals("")) {
                throw new SmooksConfigException("Invalid EnumDecoder configuration. 'enumType' param not specified.");
            }
            try {
                this.enumType = ClassUtils.forName((String)enumTypeName.trim(), EnumTypeConverter.class);
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigException("Invalid Enum decoder configuration.  Failed to resolve '" + enumTypeName + "' as a Java Enum Class.", (Throwable)e);
            }
            if (!Enum.class.isAssignableFrom(this.enumType)) {
                throw new SmooksConfigException("Invalid Enum decoder configuration.  Resolved 'enumType' '" + enumTypeName + "' is not a Java Enum Class.");
            }
            this.strict = properties.getProperty("strict", "true").equals("true");
            this.mappingTypeConverter.setConfiguration(properties);
        }

        public Properties getConfiguration() {
            return this.properties;
        }
    }
}

