/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

public class ByteConverterFactory
implements TypeConverterFactory<String, Byte> {
    public TypeConverter<String, Byte> createTypeConverter() {
        return value -> {
            try {
                return Byte.parseByte(value.trim());
            }
            catch (NumberFormatException e) {
                throw new TypeConverterException("Failed to decode Byte value '" + value + "'.", (Throwable)e);
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Byte>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Byte>>(String.class, Byte.class);
    }
}

