/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.bean.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.smooks.api.ExecutionContext;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleEvent;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.bean.lifecycle.BeanLifecycle;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.bean.lifecycle.DefaultBeanContextLifecycleEvent;
import org.smooks.support.MultiLineToStringBuilder;

public class StandaloneBeanContext
implements BeanContext {
    private final ExecutionContext executionContext;
    private final Map<String, Object> beanMap;
    private final ArrayList<ContextEntry> entries;
    private final BeanIdStore beanIdStore;
    private BeanContextMapAdapter repositoryBeanMapAdapter = new BeanContextMapAdapter();
    private List<BeanContextLifecycleObserver> lifecycleObservers = new ArrayList<BeanContextLifecycleObserver>();
    private List<BeanContextLifecycleObserver> addObserversQueue = new ArrayList<BeanContextLifecycleObserver>();
    private List<BeanContextLifecycleObserver> removeObserversQueue = new ArrayList<BeanContextLifecycleObserver>();
    private List<BeanContextLifecycleEvent> notifyObserverEventQueue = new ArrayList<BeanContextLifecycleEvent>();

    public StandaloneBeanContext(ExecutionContext executionContext, BeanIdStore beanIdStore, Map<String, Object> beanMap) {
        this.executionContext = executionContext;
        this.beanIdStore = beanIdStore;
        this.beanMap = beanMap;
        this.entries = new ArrayList(beanIdStore.size());
        this.updateBeanMap();
    }

    private StandaloneBeanContext(ExecutionContext executionContext, StandaloneBeanContext parentContext) {
        this.executionContext = executionContext;
        this.beanIdStore = parentContext.beanIdStore;
        this.beanMap = parentContext.beanMap;
        this.entries = parentContext.entries;
        this.repositoryBeanMapAdapter = parentContext.repositoryBeanMapAdapter;
        this.lifecycleObservers = parentContext.lifecycleObservers;
        this.addObserversQueue = parentContext.addObserversQueue;
        this.removeObserversQueue = parentContext.removeObserversQueue;
        this.notifyObserverEventQueue = parentContext.notifyObserverEventQueue;
    }

    public void addBean(BeanId beanId, Object bean) {
        this.addBean(beanId, bean, null);
    }

    public void addBean(BeanId beanId, Object bean, Fragment<?> source) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        Object currentInstance = this.getBean(beanId);
        if (currentInstance != null) {
            this.notifyObservers(new DefaultBeanContextLifecycleEvent(this.executionContext, source, BeanLifecycle.REMOVE, beanId, currentInstance));
        }
        this.checkUpdatedBeanIdList();
        int index = beanId.getIndex();
        ContextEntry repoEntry = this.entries.get(index);
        this.clean(index);
        repoEntry.setValue(bean);
        this.notifyObservers(new DefaultBeanContextLifecycleEvent(this.executionContext, source, BeanLifecycle.ADD, beanId, bean));
    }

    public void addBean(String beanId, Object bean) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        this.addBean(this.getBeanId(beanId), bean, null);
    }

    public void addBean(String beanId, Object bean, Fragment<?> source) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        this.addBean(this.getBeanId(beanId), bean, source);
    }

    public boolean containsBean(BeanId beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        int index = beanId.getIndex();
        return this.entries.size() > index && this.entries.get(index).getValue() != null;
    }

    public BeanId getBeanId(String beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        BeanId beanIdObj = this.beanIdStore.getBeanId(beanId);
        if (beanIdObj == null) {
            beanIdObj = this.beanIdStore.register(beanId);
        }
        return beanIdObj;
    }

    public Object getBean(BeanId beanId) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        int index = beanId.getIndex();
        if (this.entries.size() <= index) {
            return null;
        }
        return this.entries.get(index).getValue();
    }

    public Object getBean(String beanId) {
        return this.beanMap.get(beanId);
    }

    public <T> T getBean(Class<T> beanType) {
        return StandaloneBeanContext.getBean(beanType, this.beanMap);
    }

    public static <T> T getBean(Class<T> beanType, Map<String, Object> beanMap) {
        if (beanMap == null) {
            return null;
        }
        for (Object bean : beanMap.values()) {
            if (!beanType.isInstance(bean)) continue;
            return beanType.cast(bean);
        }
        return null;
    }

    public void changeBean(BeanId beanId, Object bean, Fragment<?> source) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull((Object)bean, (String)"bean");
        int index = beanId.getIndex();
        if (this.entries.size() <= index || this.entries.get(index).getValue() == null) {
            throw new IllegalStateException("The bean '" + beanId + "' can't be changed because it isn't in the repository.");
        }
        this.entries.get(index).setValue(bean);
        this.notifyObservers(new DefaultBeanContextLifecycleEvent(this.executionContext, source, BeanLifecycle.CHANGE, beanId, bean));
    }

    public Object removeBean(BeanId beanId, Fragment<?> source) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        ContextEntry repositoryEntry = this.entries.get(beanId.getIndex());
        Object old = repositoryEntry.getValue();
        repositoryEntry.clean();
        repositoryEntry.setValue(null);
        this.notifyObservers(new DefaultBeanContextLifecycleEvent(this.executionContext, source, BeanLifecycle.REMOVE, beanId, this.getBean(beanId)));
        return old;
    }

    public Object removeBean(String beanId, Fragment<?> source) {
        BeanId beanIDObj = this.getBeanId(beanId);
        if (beanIDObj != null) {
            return this.removeBean(beanIDObj, source);
        }
        return null;
    }

    public void clear() {
        for (ContextEntry entry : this.entries) {
            entry.setValue(null);
        }
    }

    public Map<String, Object> getBeanMap() {
        return this.repositoryBeanMapAdapter;
    }

    private void checkUpdatedBeanIdList() {
        if (this.entries.size() != this.beanIdStore.size()) {
            this.updateBeanMap();
        }
    }

    private void updateBeanMap() {
        BeanId beanId;
        Map beanIdMap = this.beanIdStore.getBeanIdMap();
        int largestBeanIdIndex = -1;
        for (Map.Entry beanIdEntry : beanIdMap.entrySet()) {
            String beanIdName = (String)beanIdEntry.getKey();
            beanId = (BeanId)beanIdEntry.getValue();
            if (!this.beanMap.containsKey(beanIdName)) {
                this.beanMap.put(beanIdName, null);
            }
            if (largestBeanIdIndex >= beanId.getIndex()) continue;
            largestBeanIdIndex = beanId.getIndex();
        }
        if (largestBeanIdIndex >= 0) {
            int newEntries = largestBeanIdIndex - this.entries.size() + 1;
            this.entries.addAll(Collections.nCopies(newEntries, null));
            for (Map.Entry<String, Object> beanMapEntry : this.beanMap.entrySet()) {
                beanId = (BeanId)beanIdMap.get(beanMapEntry.getKey());
                int index = beanId.getIndex();
                if (this.entries.get(index) != null) continue;
                this.entries.set(index, new ContextEntry(beanId, beanMapEntry));
            }
        }
    }

    private void clean(int beanId) {
        ContextEntry entry = this.entries.get(beanId);
        if (entry != null) {
            entry.clean();
        }
    }

    public void setBeanInContext(BeanId beanId, boolean inContext) {
        ContextEntry repositoryEntry = this.entries.get(beanId.getIndex());
        if (repositoryEntry != null) {
            repositoryEntry.setBeanInContext(inContext);
        }
    }

    public String toString() {
        return MultiLineToStringBuilder.toString(this.getBeanMap());
    }

    public BeanContext newSubContext(ExecutionContext executionContext) {
        return new StandaloneBeanContext(executionContext, this);
    }

    public void addObserver(BeanContextLifecycleObserver observer) {
        if (this.lifecycleObservers != null) {
            this.lifecycleObservers.add(observer);
        } else {
            this.addObserversQueue.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(BeanContextLifecycleEvent event) {
        if (this.lifecycleObservers != null) {
            List<BeanContextLifecycleObserver> localObserverListCopy = this.lifecycleObservers;
            this.lifecycleObservers = null;
            try {
                int observerCount = localObserverListCopy.size();
                for (BeanContextLifecycleObserver beanContextLifecycleObserver : localObserverListCopy) {
                    beanContextLifecycleObserver.onBeanLifecycleEvent(event);
                }
            }
            finally {
                this.lifecycleObservers = localObserverListCopy;
                this.syncObserverList();
            }
            if (!this.notifyObserverEventQueue.isEmpty()) {
                List<BeanContextLifecycleEvent> notifyObserverEventQueueCopy = this.notifyObserverEventQueue;
                this.notifyObserverEventQueue = new ArrayList<BeanContextLifecycleEvent>();
                for (BeanContextLifecycleEvent nestedEvent : notifyObserverEventQueueCopy) {
                    this.notifyObservers(nestedEvent);
                }
            }
        } else {
            this.notifyObserverEventQueue.add(event);
        }
    }

    public void removeObserver(BeanContextLifecycleObserver observer) {
        if (this.lifecycleObservers != null) {
            this.lifecycleObservers.remove(observer);
        } else {
            this.removeObserversQueue.add(observer);
        }
    }

    private void syncObserverList() {
        int removeObserverCount;
        int addObserverCount = this.addObserversQueue.size();
        if (addObserverCount > 0) {
            this.lifecycleObservers.addAll(this.addObserversQueue);
            this.addObserversQueue.clear();
        }
        if ((removeObserverCount = this.removeObserversQueue.size()) > 0) {
            for (BeanContextLifecycleObserver beanContextLifecycleObserver : this.removeObserversQueue) {
                this.lifecycleObservers.remove(beanContextLifecycleObserver);
            }
            this.removeObserversQueue.clear();
        }
    }

    private class BeanContextMapAdapter
    implements Map<String, Object> {
        private BeanContextMapAdapter() {
        }

        @Override
        public void clear() {
            StandaloneBeanContext.this.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return StandaloneBeanContext.this.beanMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return StandaloneBeanContext.this.beanMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.unmodifiableSet(StandaloneBeanContext.this.beanMap.entrySet());
        }

        @Override
        public Object get(Object key) {
            return StandaloneBeanContext.this.beanMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return StandaloneBeanContext.this.beanMap.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return StandaloneBeanContext.this.beanMap.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            AssertArgument.isNotNull((Object)key, (String)"key");
            BeanId beanId = StandaloneBeanContext.this.beanIdStore.getBeanId(key);
            Object old = null;
            if (beanId == null) {
                beanId = StandaloneBeanContext.this.beanIdStore.register(key);
            } else {
                old = StandaloneBeanContext.this.getBean(beanId);
            }
            StandaloneBeanContext.this.addBean(beanId, value, null);
            return old;
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            AssertArgument.isNotNull(map, (String)"map");
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                StandaloneBeanContext.this.addBean(entry.getKey(), entry.getValue(), null);
            }
        }

        @Override
        public Object remove(Object key) {
            AssertArgument.isNotNull((Object)key, (String)"key");
            if (!(key instanceof String)) {
                return null;
            }
            BeanId beanId = StandaloneBeanContext.this.beanIdStore.getBeanId((String)key);
            return beanId == null ? null : StandaloneBeanContext.this.removeBean(beanId, null);
        }

        @Override
        public int size() {
            return StandaloneBeanContext.this.beanMap.size();
        }

        @Override
        public Collection<Object> values() {
            return StandaloneBeanContext.this.beanMap.values();
        }
    }

    private class ContextEntry {
        private final BeanId beanId;
        private final Map.Entry<String, Object> entry;
        private final List<Integer> lifecycleAssociation = new ArrayList<Integer>();
        private boolean cleaning;
        private boolean beanInContext = true;

        public ContextEntry(BeanId beanId, Map.Entry<String, Object> entry) {
            this.beanId = beanId;
            this.entry = entry;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public void setValue(Object value) {
            this.entry.setValue(value);
        }

        public void clean() {
            this.clean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clean(boolean nullifyValue) {
            if (this.cleaning || this.beanInContext) {
                return;
            }
            this.setCleaning(true);
            try {
                if (!this.lifecycleAssociation.isEmpty()) {
                    for (Integer associationId : this.lifecycleAssociation) {
                        ContextEntry association = (ContextEntry)StandaloneBeanContext.this.entries.get(associationId);
                        association.clean(true);
                    }
                    this.lifecycleAssociation.clear();
                }
            }
            finally {
                if (nullifyValue) {
                    this.setValue(null);
                }
                this.setCleaning(false);
            }
        }

        public boolean isCleaning() {
            return this.cleaning;
        }

        public void setCleaning(boolean cleaning) {
            this.cleaning = cleaning;
        }

        public boolean isBeanInContext() {
            return this.beanInContext;
        }

        public void setBeanInContext(boolean beanInContext) {
            this.beanInContext = beanInContext;
        }

        public String toString() {
            return ContextEntry.class.getSimpleName() + ": Idx (" + this.beanId.getIndex() + "), Name (" + this.beanId.getName() + "), Num Associations (" + this.lifecycleAssociation.size() + ").";
        }
    }
}

