/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import java.util.ServiceLoader;
import java.util.function.Function;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.FilterSettings;
import org.smooks.api.Registry;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.delivery.ContentDeliveryRuntimeFactory;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.ReaderPoolFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;
import org.smooks.engine.DefaultApplicationContext;
import org.smooks.engine.DefaultFilterSettings;
import org.smooks.engine.DefaultRegistry;
import org.smooks.engine.bean.context.DefaultBeanIdStore;
import org.smooks.engine.delivery.DefaultContentDeliveryRuntimeFactory;
import org.smooks.engine.delivery.DefaultReaderPoolFactory;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.profile.DefaultProfileSet;
import org.smooks.engine.resource.config.GlobalParamsResourceConfig;
import org.smooks.engine.resource.config.SystemResourceConfigSeqFactory;
import org.smooks.engine.resource.config.loader.xml.XmlResourceConfigLoader;
import org.smooks.io.payload.Exports;
import org.smooks.resource.URIResourceLocator;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    protected boolean systemResources = true;
    protected BeanIdStore beanIdStore = new DefaultBeanIdStore();
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected Registry registry;
    protected ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory;
    protected ContainerResourceLocator resourceLocator = new URIResourceLocator();
    protected ResourceConfigLoader resourceConfigLoader = new XmlResourceConfigLoader();
    protected ReaderPoolFactory readerPoolFactory = new DefaultReaderPoolFactory();
    protected FilterSettings filterSettings = new DefaultFilterSettings();

    public DefaultApplicationContextBuilder() {
    }

    protected DefaultApplicationContextBuilder(boolean systemResources, ClassLoader classLoader, Registry registry, ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory, ContainerResourceLocator resourceLocator, ResourceConfigLoader resourceConfigLoader, ReaderPoolFactory readerPoolFactory, BeanIdStore beanIdStore, FilterSettings filterSettings) {
        this.systemResources = systemResources;
        this.classLoader = classLoader;
        this.registry = registry;
        this.contentDeliveryRuntimeFactory = contentDeliveryRuntimeFactory;
        this.resourceLocator = resourceLocator;
        this.resourceConfigLoader = resourceConfigLoader;
        this.readerPoolFactory = readerPoolFactory;
        this.beanIdStore = beanIdStore;
        this.filterSettings = filterSettings;
    }

    public DefaultApplicationContextBuilder withClassLoader(ClassLoader classLoader) {
        return new DefaultApplicationContextBuilder(this.systemResources, classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withSystemResources(boolean systemResources) {
        return new DefaultApplicationContextBuilder(systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withRegistry(Registry registry) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withContentDeliveryRuntimeFactory(ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withResourceLocator(ContainerResourceLocator resourceLocator) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withResourceConfigLoader(ResourceConfigLoader resourceConfigLoader) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withReaderPoolFactory(ReaderPoolFactory readerPoolFactory) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, readerPoolFactory, this.beanIdStore, this.filterSettings);
    }

    public DefaultApplicationContextBuilder withBeanIdStore(BeanIdStore beanIdStore) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, beanIdStore, this.filterSettings);
    }

    public ApplicationContextBuilder withFilterSettings(FilterSettings filterSettings) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory, this.beanIdStore, filterSettings);
    }

    public ApplicationContext build() {
        DefaultApplicationContext applicationContext = new DefaultApplicationContext();
        applicationContext.setClassLoader(this.classLoader);
        applicationContext.setResourceConfigLoader(this.resourceConfigLoader);
        applicationContext.setReaderPoolFactory(this.readerPoolFactory);
        applicationContext.setResourceLocator(this.resourceLocator);
        applicationContext.setBeanIdStore(this.beanIdStore);
        Registry applicationContextRegistry = this.registry == null ? new DefaultRegistry(applicationContext.getClassLoader(), applicationContext.getResourceConfigLoader(), applicationContext.getProfileStore()) : this.registry;
        this.initRegistry(applicationContext, applicationContextRegistry);
        applicationContext.setRegistry(applicationContextRegistry);
        if (this.contentDeliveryRuntimeFactory == null) {
            applicationContext.setContentDeliveryRuntimeFactory(new DefaultContentDeliveryRuntimeFactory(applicationContext.getRegistry(), applicationContext.getReaderPoolFactory()));
        } else {
            applicationContext.setContentDeliveryRuntimeFactory(this.contentDeliveryRuntimeFactory);
        }
        applicationContext.getProfileStore().addProfileSet((ProfileSet)new DefaultProfileSet(Profile.DEFAULT_PROFILE));
        this.applySettings(this.filterSettings, applicationContextRegistry);
        return applicationContext;
    }

    protected void applySettings(FilterSettings filterSettings, Registry registry) {
        this.setParameter("stream.filter.type", filterSettings.getFilterType().getName(), registry);
        this.setParameter("entities.rewrite", Boolean.toString(filterSettings.isRewriteEntities()), registry);
        this.setParameter("default.serialization.on", Boolean.toString(filterSettings.isDefaultSerializationOn()), registry);
        this.setParameter("terminate.on.visitor.exception", Boolean.toString(filterSettings.isTerminateOnException()), registry);
        this.setParameter("close.source", Boolean.toString(filterSettings.isCloseSource()), registry);
        this.setParameter("close.sink", Boolean.toString(filterSettings.isCloseSink()), registry);
        this.setParameter("reader.pool.size", Integer.toString(filterSettings.getReaderPoolSize()), registry);
        this.setParameter("max.node.depth", Integer.toString(filterSettings.getMaxNodeDepth()), registry);
    }

    protected void initRegistry(ApplicationContext applicationContext, Registry registry) {
        registry.registerObject(ApplicationContext.class, (Object)applicationContext);
        registry.registerObject(Exports.class, (Object)new Exports());
        this.registerSystemContentHandlerFactories(registry);
        if (this.systemResources) {
            this.registerSystemResources(registry, applicationContext);
        }
    }

    protected void registerSystemContentHandlerFactories(Registry registry) {
        for (ContentHandlerFactory contentHandlerFactory : ServiceLoader.load(ContentHandlerFactory.class, this.classLoader)) {
            ((LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup())).applyPhase((Object)contentHandlerFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(registry)));
            registry.registerObject((Object)contentHandlerFactory);
        }
    }

    protected void registerSystemResources(Registry registry, ApplicationContext applicationContext) {
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/null-dom.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/null-sax.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-param-decoders.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-serializers.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-interceptors.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
    }

    protected void setParameter(String name, Object value, Registry registry) {
        GlobalParamsResourceConfig globalParamsResourceConfig = new GlobalParamsResourceConfig();
        globalParamsResourceConfig.setParameter(name, value);
        registry.registerResourceConfig((ResourceConfig)globalParamsResourceConfig);
    }
}

