/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.smooks.api.SmooksException;
import org.smooks.assertion.AssertArgument;

public class FreeMarkerTemplate {
    public static final String DEFAULT_MACHINE_READABLE_NUMBER_FORMAT = "#.##########";
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    private final String templateText;
    private final Template template;

    public FreeMarkerTemplate(String templateText) {
        this(templateText, FreeMarkerTemplate.createDefaultConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeMarkerTemplate(String templateText, Configuration config) {
        AssertArgument.isNotNullAndNotEmpty(templateText, "templateText");
        this.templateText = templateText;
        StringReader templateReader = new StringReader(templateText);
        try {
            try {
                this.template = new Template("free-marker-template", (Reader)templateReader, config);
            }
            finally {
                ((Reader)templateReader).close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception creating FreeMarker Template instance for template:" + LINE_SEPARATOR + LINE_SEPARATOR + "[" + templateText + "]" + LINE_SEPARATOR + LINE_SEPARATOR, e);
        }
    }

    public FreeMarkerTemplate(String templatePath, Class basePath) {
        this(templatePath, basePath, FreeMarkerTemplate.createDefaultConfiguration());
    }

    public FreeMarkerTemplate(String templatePath, Class basePath, Configuration config) {
        AssertArgument.isNotNullAndNotEmpty(templatePath, "templatePath");
        this.templateText = templatePath;
        try {
            if (basePath != null) {
                config.setClassForTemplateLoading(basePath, "");
            }
            this.template = config.getTemplate(templatePath);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public String apply(Object contextObject) {
        StringWriter outputWriter = new StringWriter();
        this.apply(contextObject, outputWriter);
        return outputWriter.toString();
    }

    public void apply(Object contextObject, Writer outputWriter) {
        try {
            this.template.process(contextObject, outputWriter);
        }
        catch (TemplateException e) {
            throw new SmooksException("Failed to apply template.", (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException.", e);
        }
    }

    private static Configuration createDefaultConfiguration() {
        Configuration config = new Configuration(Configuration.VERSION_2_3_30);
        config.setNumberFormat(DEFAULT_MACHINE_READABLE_NUMBER_FORMAT);
        return config;
    }
}

