/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.support;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.assertion.AssertArgument;
import org.smooks.classpath.InstanceOfFilter;
import org.smooks.classpath.IsAnnotationPresentFilter;
import org.smooks.classpath.Scanner;

public final class ClassUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);
    private static final Map<String, Class<?>> primitives = new HashMap();

    private ClassUtils() {
    }

    public static Class<?> forName(String className, Class<?> caller) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> primitiveClass = primitives.get(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        if (threadClassLoader != null) {
            try {
                return threadClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((classLoader = caller.getClassLoader()) != null) {
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> caller) {
        if (!resourceName.startsWith("/")) {
            Package callerPackage = caller.getPackage();
            String resource = callerPackage != null ? callerPackage.getName().replace('.', '/') + '/' + resourceName : resourceName;
            return ClassUtils.getResourceAsStream(resource, caller.getClassLoader());
        }
        return ClassUtils.getResourceAsStream(resourceName, caller.getClassLoader());
    }

    public static InputStream getResourceAsStream(String resourceName, ClassLoader classLoader) {
        InputStream is;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        String resource = resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
        if (threadClassLoader != null && (is = threadClassLoader.getResourceAsStream(resource)) != null) {
            return is;
        }
        if (classLoader != null && (is = classLoader.getResourceAsStream(resource)) != null) {
            return is;
        }
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static List<URL> getResources(String resourcePath, Class<?> caller) throws IOException {
        return ClassUtils.getResources(resourcePath, caller.getClassLoader());
    }

    public static List<URL> getResources(String resourcePath, ClassLoader callerClassLoader) throws IOException {
        ClassLoader contextClassLoader;
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            resources.addAll(Collections.list(contextClassLoader.getResources(resourcePath)));
        }
        if (callerClassLoader != null) {
            resources.addAll(Collections.list(callerClassLoader.getResources(resourcePath)));
        }
        return new ArrayList<URL>(resources);
    }

    public static List<Class<?>> findInstancesOf(Class<?> type, String[] igrnoreList, String[] includeList) {
        InstanceOfFilter filter = new InstanceOfFilter(type, igrnoreList, includeList);
        return ClassUtils.findInstancesOf(type, filter);
    }

    public static List<Class<?>> findInstancesOf(Class<?> type) {
        InstanceOfFilter filter = new InstanceOfFilter(type);
        return ClassUtils.findInstancesOf(type, filter);
    }

    private static List<Class<?>> findInstancesOf(Class<?> type, InstanceOfFilter filter) {
        Scanner scanner = new Scanner(filter);
        try {
            long startTime = System.currentTimeMillis();
            scanner.scanClasspath(Thread.currentThread().getContextClassLoader());
            LOGGER.debug("Scanned classpath for instances of '" + type.getName() + "'.  Found " + filter.getClasses().size() + " matches. Scan took " + (System.currentTimeMillis() - startTime) + "ms.");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to search classspath for instances of '" + type.getName() + "'.", e);
        }
        return filter.getClasses();
    }

    public static List<Class<?>> findAnnotatedWith(Class<? extends Annotation> type, String[] igrnoreList, String[] includeList) {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(type, igrnoreList, includeList);
        return ClassUtils.findAnnotatedWith(type, filter);
    }

    public static List<Class<?>> findAnnotatedWith(Class<? extends Annotation> type) {
        IsAnnotationPresentFilter filter = new IsAnnotationPresentFilter(type);
        return ClassUtils.findAnnotatedWith(type, filter);
    }

    private static List<Class<?>> findAnnotatedWith(Class<? extends Annotation> type, IsAnnotationPresentFilter filter) {
        Scanner scanner = new Scanner(filter);
        try {
            long startTime = System.currentTimeMillis();
            scanner.scanClasspath(Thread.currentThread().getContextClassLoader());
            LOGGER.debug("Scanned classpath for class annotated with annotation '" + type.getName() + "'.  Found " + filter.getClasses().size() + " matches. Scan took " + (System.currentTimeMillis() - startTime) + "ms.");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to search classspath for class annotated with annotation '" + type.getName() + "'.", e);
        }
        return filter.getClasses();
    }

    public static Object newProxyInstance(Class[] classes, InvocationHandler handler) {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null) {
            return Proxy.newProxyInstance(threadClassLoader, classes, handler);
        }
        return Proxy.newProxyInstance(ClassUtils.class.getClassLoader(), classes, handler);
    }

    public static <T> List<Class<T>> getClasses(String fileName, Class<T> instanceOf) {
        List<URL> cpURLs;
        AssertArgument.isNotNull(fileName, "fileName");
        AssertArgument.isNotNull(instanceOf, "instanceOf");
        long start = System.currentTimeMillis();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        int resCount = 0;
        try {
            cpURLs = ClassUtils.getResources(fileName, ClassUtils.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting resource URLs for resource : " + fileName, e);
        }
        for (URL url : cpURLs) {
            ClassUtils.addClasses(url, instanceOf, classes);
            ++resCount;
        }
        LOGGER.debug("Loaded " + classes.size() + " classes from " + resCount + " URLs through class list file " + fileName + ".  Process took " + (System.currentTimeMillis() - start) + "ms.  Turn on debug logging for more info.");
        return classes;
    }

    private static <T> void addClasses(URL url, Class<T> instanceOf, List<Class<T>> classes) {
        InputStream ins = null;
        BufferedReader br = null;
        try {
            String className;
            int count = 0;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(true);
            ins = connection.getInputStream();
            br = new BufferedReader(new InputStreamReader(ins));
            while ((className = br.readLine()) != null) {
                Class<?> clazz;
                if ((className = className.trim()).equals("") || className.startsWith("#")) continue;
                try {
                    clazz = ClassUtils.forName(className, ClassUtils.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.debug("Failed to load class '" + className + "'. Class not found.", (Throwable)e);
                    continue;
                }
                if (instanceOf.isAssignableFrom(clazz)) {
                    if (!ClassUtils.contains(clazz.getName(), classes)) {
                        classes.add(clazz);
                    }
                    LOGGER.debug("Adding " + className + " to list of classes");
                    ++count;
                    continue;
                }
                LOGGER.debug("Not adding class '" + clazz.getName() + "' to list.  Class does not implement/extend '" + instanceOf.getName() + "'.");
            }
            LOGGER.debug("Loaded '" + count + "' classes listed in '" + url + "'.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to read from file : " + url, e);
            }
            catch (Throwable throwable) {
                ClassUtils.close(br);
                ClassUtils.close(ins);
                throw throwable;
            }
        }
        ClassUtils.close(br);
        ClassUtils.close(ins);
    }

    private static <T> boolean contains(String name, List<Class<T>> classes) {
        for (Class<T> aClass : classes) {
            if (!aClass.getName().equals(name)) continue;
            LOGGER.debug("Class '" + name + "' already found on classpath.  Not adding to list.");
            return true;
        }
        return false;
    }

    private static void close(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                LOGGER.debug("Exception while trying to close : " + closable, (Throwable)e);
            }
        }
    }

    public static String toFilePath(Package aPackage) {
        return "/" + aPackage.getName().replace('.', '/');
    }

    public static boolean containsAssignableClass(Class<?> toFind, Class<?> ... classes) {
        return ClassUtils.indexOfFirstAssignableClass(toFind, classes) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <U> void setField(Field field, U instance, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        if (!isAccessible) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <U> Object getField(Field field, U instance) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        if (!isAccessible) {
            field.setAccessible(true);
        }
        try {
            Object object = field.get(instance);
            return object;
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static List<Field> getAnnotatedFields(Class runtimeClass, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> streamWriterFields = new ArrayList<Field>();
        ClassUtils.getAnnotatedFields(runtimeClass, streamWriterFields, annotationClass);
        return streamWriterFields;
    }

    private static void getAnnotatedFields(Class runtimeClass, List<Field> annotatedFields, Class<? extends Annotation> annotationClass) {
        Field[] fields = runtimeClass.getDeclaredFields();
        Class superClass = runtimeClass.getSuperclass();
        if (superClass != null) {
            ClassUtils.getAnnotatedFields(superClass, annotatedFields, annotationClass);
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
    }

    public static int indexOfFirstAssignableClass(Class<?> toFind, Class<?> ... classes) {
        for (int i = 0; i < classes.length; ++i) {
            Class<?> cls = classes[i];
            if (!cls.isAssignableFrom(toFind)) continue;
            return i;
        }
        return -1;
    }

    public static String toSetterName(String property) {
        StringBuilder setterName = new StringBuilder();
        setterName.append(property);
        setterName.setCharAt(0, Character.toUpperCase(property.charAt(0)));
        setterName.insert(0, "set");
        return setterName.toString();
    }

    public static String toGetterName(String property) {
        StringBuilder getterName = new StringBuilder();
        getterName.append(property);
        getterName.setCharAt(0, Character.toUpperCase(property.charAt(0)));
        getterName.insert(0, "get");
        return getterName.toString();
    }

    public static String toIsGetterName(String property) {
        StringBuilder getterName = new StringBuilder();
        getterName.append(property);
        getterName.setCharAt(0, Character.toUpperCase(property.charAt(0)));
        getterName.insert(0, "is");
        return getterName.toString();
    }

    public static Method getSetterMethod(String setterName, Object bean, Class<?> setterParamType) {
        return ClassUtils.getSetterMethod(setterName, bean.getClass(), setterParamType);
    }

    public static Method getSetterMethod(String setterName, Class beanclass, Class<?> setterParamType) {
        Method[] methods;
        for (Method method : methods = beanclass.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(setterName) || (params = method.getParameterTypes()).length != 1 || !params[0].isAssignableFrom(setterParamType)) continue;
            return method;
        }
        return null;
    }

    static Method getSetterMethodByProperty(String propertyName, Class<?> beanClass, Class<?> setterParamType) {
        return ClassUtils.getSetterMethod(ClassUtils.toSetterName(propertyName), beanClass, setterParamType);
    }

    public static Method getGetterMethod(String getterName, Object bean, Class<?> returnType) {
        return ClassUtils.getGetterMethod(getterName, bean.getClass(), returnType);
    }

    private static Method getGetterMethod(String getterName, Class beanclass, Class<?> returnType) {
        Method[] methods;
        for (Method method : methods = beanclass.getMethods()) {
            if (!method.getName().equals(getterName)) continue;
            if (returnType != null) {
                if (!method.getReturnType().isAssignableFrom(returnType)) continue;
                return method;
            }
            return method;
        }
        return null;
    }

    public static Method getGetterMethodByProperty(String propertyName, Class<?> beanClass, Class<?> returnType) {
        Method getter = ClassUtils.getGetterMethod(ClassUtils.toGetterName(propertyName), beanClass, returnType);
        if (getter == null) {
            getter = ClassUtils.getGetterMethod(ClassUtils.toIsGetterName(propertyName), beanClass, returnType);
        }
        return getter;
    }

    public static String getLongMemberName(Member field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public static String toClassName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null 'fileName' arg in method call.");
        }
        if ((fileName = fileName.trim()).equals("")) {
            throw new IllegalArgumentException("empty 'fileName' arg in method call.");
        }
        StringBuffer className = new StringBuffer(fileName);
        if (fileName.endsWith(".class") && fileName.length() > 6) {
            className.setLength(className.length() - 6);
        }
        for (int i = 0; i < className.length(); ++i) {
            if (className.charAt(i) != '/') continue;
            className.setCharAt(i, '.');
        }
        return className.toString();
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
    }
}

