/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.templating;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.xml.transform.TransformerConfigurationException;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.cartridges.templating.TemplatingConfiguration;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.io.Stream;
import org.w3c.dom.Element;

public abstract class AbstractTemplateProcessor
implements BeforeVisitor,
AfterVisitor {
    public static final String TEMPLATE_SPLIT_PI = "<\\?TEMPLATE-SPLIT-PI\\?>";
    private TemplatingConfiguration templatingConfiguration;
    @Inject
    private Boolean applyTemplateBefore = false;
    @Inject
    private Charset encoding = StandardCharsets.UTF_8;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void postConstruct() {
        if (this.templatingConfiguration != null) {
            DefaultResourceConfig config = new DefaultResourceConfig();
            config.setResource(this.templatingConfiguration.getTemplate());
            try {
                this.loadTemplate((ResourceConfig)config);
            }
            catch (Exception e) {
                throw new SmooksConfigException("Error loading Templating resource: " + config, (Throwable)e);
            }
        } else if (this.resourceConfig != null) {
            if (this.resourceConfig.getResource() == null) {
                throw new SmooksConfigException("Templating resource undefined in resource configuration: " + this.resourceConfig);
            }
            try {
                this.loadTemplate(this.resourceConfig);
            }
            catch (Exception e) {
                throw new SmooksConfigException("Error loading Templating resource: " + this.resourceConfig, (Throwable)e);
            }
        } else {
            throw new SmooksConfigException(this.getClass().getSimpleName() + " not configured.");
        }
    }

    protected void setTemplatingConfiguration(TemplatingConfiguration templatingConfiguration) {
        AssertArgument.isNotNull((Object)templatingConfiguration, (String)"templatingConfiguration");
        this.templatingConfiguration = templatingConfiguration;
    }

    protected abstract void loadTemplate(ResourceConfig var1) throws IOException, TransformerConfigurationException;

    public boolean applyTemplateBefore() {
        return this.applyTemplateBefore;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.applyTemplateBefore()) {
            this.applyTemplate(element, executionContext, Stream.out((ExecutionContext)executionContext));
        }
    }

    protected abstract void applyTemplate(Element var1, ExecutionContext var2, Writer var3);

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.applyTemplateBefore()) {
            this.applyTemplate(element, executionContext, Stream.out((ExecutionContext)executionContext));
        }
    }
}

