/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.gen.model;

import jakarta.annotation.Resource;
import java.lang.reflect.Field;
import java.util.Set;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.lookup.converter.SourceTargetTypeConverterFactoryLookup;

public class BindingConfig {
    protected final Set<TypeConverterFactory<?, ?>> typeConverterFactories;
    protected final Field property;
    protected final String wireBeanId;

    public BindingConfig(Field property, Set<TypeConverterFactory<?, ?>> typeConverterFactories) {
        this(property, null, typeConverterFactories);
    }

    public BindingConfig(String wireBeanId, Set<TypeConverterFactory<?, ?>> typeConverterFactories) {
        this(null, wireBeanId, typeConverterFactories);
    }

    public BindingConfig(Field property, String wireBeanId, Set<TypeConverterFactory<?, ?>> typeConverterFactories) {
        this.property = property;
        this.wireBeanId = wireBeanId;
        this.typeConverterFactories = typeConverterFactories;
    }

    public Field getProperty() {
        return this.property;
    }

    public String getSelector() {
        if (this.wireBeanId != null) {
            return this.wireBeanId;
        }
        return "$TODO$";
    }

    public boolean isWiring() {
        return this.wireBeanId != null;
    }

    public boolean isBoundToProperty() {
        return this.property != null;
    }

    public String getType() {
        Class<?> type = this.property.getType();
        if (type.isArray()) {
            return "$DELETE:NOT-APPLICABLE$";
        }
        TypeConverterFactory typeConverterFactory = new SourceTargetTypeConverterFactoryLookup(String.class, type).lookup(this.typeConverterFactories);
        if (typeConverterFactory != null && typeConverterFactory.getClass().isAnnotationPresent(Resource.class) && !typeConverterFactory.getClass().getAnnotation(Resource.class).name().equals("")) {
            return typeConverterFactory.getClass().getAnnotation(Resource.class).name();
        }
        return "$TODO$";
    }
}

