/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.dynamic.ext;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.cartridges.javabean.ext.BeanConfigUtil;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.w3c.dom.Element;

public class BeanClassLookup
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = (ExtensionContext)executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
        ResourceConfig dmbWriterConfig = (ResourceConfig)extensionContext.getResourceStack().peek();
        if (dmbWriterConfig.getParameterValue("beanClass", String.class) == null) {
            String beanId = (String)dmbWriterConfig.getParameterValue("beanId", String.class);
            if (beanId == null) {
                throw new SmooksConfigException("One of the 'beanClass' or 'beanId' attributes must be configured on the <dmb:writer> configuration.");
            }
            ResourceConfig beanCreatorConfig = BeanConfigUtil.findBeanCreatorConfig(beanId, executionContext);
            if (beanCreatorConfig == null) {
                throw new SmooksConfigException("Cannot find <jb:bean> configuration for beanId '" + beanId + "' for <dmb:writer>.  Reordered <dmb:writer> after <jb:bean> config.");
            }
            String beanClass = (String)beanCreatorConfig.getParameterValue("beanClass", String.class);
            if (beanClass == null) {
                throw new SmooksConfigException("Cannot create find BeanWriter for beanId '" + beanId + "'.  The associated <jb:bean> configuration does not define a bean Class name.");
            }
            dmbWriterConfig.setParameter("beanClass", (Object)beanClass);
        }
    }
}

