/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.javabean.binding.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.cartridges.javabean.BeanInstanceCreator;
import org.smooks.cartridges.javabean.BeanInstancePopulator;
import org.smooks.cartridges.javabean.binding.model.Bean;
import org.smooks.cartridges.javabean.binding.model.Binding;
import org.smooks.cartridges.javabean.binding.model.DataBinding;
import org.smooks.cartridges.javabean.binding.model.WiredBinding;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.CustomResourceConfigSeqLookup;
import org.smooks.engine.xml.NamespaceManager;

public class ModelSet {
    protected Map<String, Bean> baseBeans = new LinkedHashMap<String, Bean>();
    protected Map<String, Bean> models = new LinkedHashMap<String, Bean>();
    protected Boolean isBindingOnlyConfig;

    public ModelSet(ResourceConfigSeq userConfigList, ContentHandlerFactory<?> javaContentHandlerFactory) throws SmooksConfigException {
        this.createBaseBeanMap(userConfigList, javaContentHandlerFactory);
        this.createExpandedModels();
        this.resolveModelSelectors(userConfigList);
    }

    public Bean getModel(String beanId) {
        return this.models.get(beanId);
    }

    public Bean getModel(Class<?> beanType) {
        for (Bean model : this.models.values()) {
            if (model.getCreator().getBeanRuntimeInfo().getPopulateType() != beanType) continue;
            return model;
        }
        return null;
    }

    public Map<String, Bean> getModels() {
        return this.models;
    }

    public boolean isBindingOnlyConfig() {
        return this.isBindingOnlyConfig;
    }

    protected void createBaseBeanMap(ResourceConfigSeq resourceConfigSeq, ContentHandlerFactory<?> contentHandlerFactory) {
        for (int i = 0; i < resourceConfigSeq.size(); ++i) {
            Bean bean;
            ResourceConfig resourceConfig = resourceConfigSeq.get(i);
            Object javaResource = resourceConfig.isJavaResource() ? contentHandlerFactory.create(resourceConfig) : null;
            if (javaResource instanceof BeanInstanceCreator) {
                BeanInstanceCreator beanCreator = (BeanInstanceCreator)javaResource;
                bean = new Bean(beanCreator).setCloneable(true);
                this.baseBeans.put(bean.getBeanId(), bean);
                if (this.isBindingOnlyConfig != null) continue;
                this.isBindingOnlyConfig = true;
                continue;
            }
            if (javaResource instanceof BeanInstancePopulator) {
                BeanInstancePopulator beanPopulator = (BeanInstancePopulator)javaResource;
                bean = this.baseBeans.get(beanPopulator.getBeanId());
                if (bean == null) {
                    throw new SmooksConfigException("Unexpected binding configuration exception.  Unknown parent beanId '' for binding configuration.");
                }
                if (beanPopulator.isBeanWiring()) {
                    bean.getBindings().add(new WiredBinding(beanPopulator));
                    continue;
                }
                bean.getBindings().add(new DataBinding(beanPopulator));
                continue;
            }
            if (!this.isNonBindingResource(javaResource) || this.isGlobalParamsConfig(resourceConfig)) continue;
            this.isBindingOnlyConfig = false;
        }
    }

    protected boolean isNonBindingResource(Object javaResource) {
        if (javaResource instanceof TypeConverterFactory) {
            return false;
        }
        return !(javaResource instanceof NamespaceManager);
    }

    protected boolean isGlobalParamsConfig(ResourceConfig config) {
        return "global-parameters".equals(config.getSelectorPath().getSelector());
    }

    protected void createExpandedModels() {
        for (Bean bean : this.baseBeans.values()) {
            this.models.put(bean.getBeanId(), bean.clone(this.baseBeans, null));
        }
    }

    protected void resolveModelSelectors(ResourceConfigSeq userConfigList) {
        for (Bean model : this.models.values()) {
            this.resolveModelSelectors(model);
        }
    }

    protected void resolveModelSelectors(Bean model) {
        for (Binding binding : model.getBindings()) {
            if (!(binding instanceof WiredBinding)) continue;
            this.resolveModelSelectors(((WiredBinding)binding).getWiredBean());
        }
    }

    public static void build(ApplicationContext appContext) {
        ModelSet modelSet = ModelSet.get(appContext);
        if (modelSet == null) {
            modelSet = new ModelSet((ResourceConfigSeq)appContext.getRegistry().lookup((Function)new CustomResourceConfigSeqLookup(appContext.getRegistry())), (ContentHandlerFactory)appContext.getRegistry().lookup((Function)new ContentHandlerFactoryLookup("class")));
            appContext.getRegistry().registerObject(ModelSet.class, (Object)modelSet);
        }
    }

    public static ModelSet get(ApplicationContext appContext) {
        return (ModelSet)appContext.getRegistry().lookup(ModelSet.class);
    }
}

