/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.smime;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import org.jetbrains.annotations.Nullable;

public class SmimeMessageIdFixingMimeMessage
extends MimeMessage {
    @Nullable
    private final String messageId;

    public SmimeMessageIdFixingMimeMessage(Session session, @Nullable String messageId) {
        super(session);
        this.messageId = messageId;
    }

    protected void updateMessageID() throws MessagingException {
        if (this.messageId == null || this.messageId.length() == 0) {
            super.updateMessageID();
        } else {
            this.setHeader("Message-ID", this.messageId);
        }
    }

    public String toString() {
        try {
            return String.format("SmimeMimeMessage<id:%s, subject:%s>", super.getMessageID(), super.getSubject());
        }
        catch (MessagingException e) {
            throw new IllegalStateException("should not reach here");
        }
    }
}

