/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.smime;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.simplejavamail.utils.mail.smime.SmimeException;
import org.simplejavamail.utils.mail.smime.SmimeKey;

public class SmimeKeyStore {
    private final KeyStore keyStore;

    public SmimeKeyStore(InputStream stream, char[] password) {
        this(stream, password, true);
    }

    public SmimeKeyStore(InputStream stream, char[] password, boolean discardPassword) {
        try {
            this.keyStore = KeyStore.getInstance("PKCS12", "BC");
            this.keyStore.load(stream, password);
        }
        catch (Exception e) {
            throw new SmimeException("Couldn't initialize SmimeKeyStore", e);
        }
        finally {
            if (discardPassword) {
                this.overwrite(password);
            }
        }
    }

    private void overwrite(char[] password) {
        if (null != password) {
            int n = password.length;
            for (int i = 0; i < n; ++i) {
                password[i] = '\u0000';
            }
        }
    }

    public int size() {
        try {
            return this.keyStore.size();
        }
        catch (KeyStoreException e) {
            throw new SmimeException("Couldn't retrieve the number of entries from SmimeKeyStore", e);
        }
    }

    public SmimeKey getPrivateKey(String alias, char[] password) {
        return this.getPrivateKey(alias, password, true);
    }

    public SmimeKey getPrivateKey(String alias, char[] password, boolean discardPassword) {
        try {
            if (this.containsPrivateKeyAlias(alias)) {
                PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, password);
                Certificate[] certificateChain = this.keyStore.getCertificateChain(alias);
                SmimeKey smimeKey = new SmimeKey(privateKey, this.copy(certificateChain));
                return smimeKey;
            }
            SmimeKey privateKey = null;
            return privateKey;
        }
        catch (Exception e) {
            throw new SmimeException("Couldn't recover SmimeKey from SmimeKeyStore", e);
        }
        finally {
            if (discardPassword) {
                this.overwrite(password);
            }
        }
    }

    private X509Certificate[] copy(Certificate[] certificateChain) {
        X509Certificate[] x509certificateChain = new X509Certificate[certificateChain.length];
        int n = certificateChain.length;
        for (int i = 0; i < n; ++i) {
            x509certificateChain[i] = (X509Certificate)certificateChain[i];
        }
        return x509certificateChain;
    }

    public Set<String> getPrivateKeyAliases() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            HashSet<String> aliasSet = new HashSet<String>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias)) continue;
                aliasSet.add(alias);
            }
            return Collections.unmodifiableSet(aliasSet);
        }
        catch (Exception e) {
            throw new SmimeException("Couldn't recover aliases from SmimeKeyStore", e);
        }
    }

    public boolean containsPrivateKeyAlias(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias);
        }
        catch (Exception e) {
            throw new SmimeException("Couldn't recover aliases from SmimeKeyStore", e);
        }
    }
}

