/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyServerSyncingClosure
implements Runnable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractProxyServerSyncingClosure.class);
    @NotNull
    private final AtomicInteger smtpConnectionCounter;
    @Nullable
    private final AnonymousSocks5Server proxyServer;

    AbstractProxyServerSyncingClosure(@NotNull AtomicInteger smtpConnectionCounter, @Nullable AnonymousSocks5Server proxyServer) {
        this.smtpConnectionCounter = smtpConnectionCounter;
        this.proxyServer = proxyServer;
        this.increaseSmtpConnectionCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Not sure why we needed this anymore, but it doesn't do any harm either")
    private void increaseSmtpConnectionCounter() {
        AtomicInteger atomicInteger = this.smtpConnectionCounter;
        synchronized (atomicInteger) {
            this.smtpConnectionCounter.incrementAndGet();
        }
    }

    @Override
    public final void run() {
        try {
            this.startProxyServerIfNeeded();
            this.executeClosure();
        }
        finally {
            this.shutDownProxyServerIfRunningAndCurrentBatchCompleted();
        }
    }

    abstract void executeClosure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProxyServerIfNeeded() {
        if (this.proxyServer != null) {
            AnonymousSocks5Server anonymousSocks5Server = this.proxyServer;
            synchronized (anonymousSocks5Server) {
                if (!this.proxyServer.isRunning()) {
                    LOGGER.trace("starting proxy bridge");
                    this.proxyServer.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Not sure why we needed this anymore, but it doesn't do any harm either")
    private void shutDownProxyServerIfRunningAndCurrentBatchCompleted() {
        AtomicInteger atomicInteger = this.smtpConnectionCounter;
        synchronized (atomicInteger) {
            if (this.smtpConnectionCounter.decrementAndGet() == 0) {
                LOGGER.trace("all threads have finished processing");
                if (this.proxyServer != null) {
                    AnonymousSocks5Server anonymousSocks5Server = this.proxyServer;
                    synchronized (anonymousSocks5Server) {
                        if (this.proxyServer.isRunning() && !this.proxyServer.isStopping()) {
                            LOGGER.trace("stopping proxy bridge...");
                            this.proxyServer.stop();
                        }
                    }
                }
            } else {
                LOGGER.trace("SMTP request threads left: {}", (Object)this.smtpConnectionCounter.get());
            }
        }
    }
}

