/*
 * Copyright © 2009 John Doe (johndoe@mysteryministry.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simplejavamail.mailer.internal;

import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.Pkcs12Config;

import java.util.EnumSet;

/**
 * @see EmailGovernance
 */
class EmailGovernanceImpl implements EmailGovernance {
	@NotNull private final EnumSet<EmailAddressCriteria> emailAddressCriteria;
	@Nullable private final Pkcs12Config pkcs12ConfigForSmimeSigning;

	EmailGovernanceImpl(@NotNull final EnumSet<EmailAddressCriteria> emailAddressCriteria, @Nullable final Pkcs12Config pkcs12ConfigForSmimeSigning) {
		this.emailAddressCriteria = emailAddressCriteria;
		this.pkcs12ConfigForSmimeSigning = pkcs12ConfigForSmimeSigning;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("EmailGovernanceImpl{");
		sb.append("emailAddressCriteria=").append(emailAddressCriteria);
		sb.append(", pkcs12ConfigForSmimeSigning=").append(pkcs12ConfigForSmimeSigning);
		sb.append('}');
		return sb.toString();
	}

	/**
	 * @see EmailGovernance#getEmailAddressCriteria()
	 */
	@Override
	public @NotNull EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
		return emailAddressCriteria;
	}

	/**
	 * @see EmailGovernance#getPkcs12ConfigForSmimeSigning()
	 */
	@Override
	public @Nullable Pkcs12Config getPkcs12ConfigForSmimeSigning() {
		return pkcs12ConfigForSmimeSigning;
	}
}