/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public final class Pkcs12Config {
    private static final long serialVersionUID = 1234567L;
    @NotNull
    private final InputStream pkcs12StoreStream;
    @NotNull
    private final char[] storePassword;
    @NotNull
    private final String keyAlias;
    @NotNull
    private final char[] keyPassword;

    private Pkcs12Config(@NotNull InputStream pkcs12StoreStream, @NotNull char[] storePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        this.pkcs12StoreStream = pkcs12StoreStream;
        this.storePassword = storePassword;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    public static Pkcs12ConfigBuilder builder() {
        return new Pkcs12ConfigBuilder();
    }

    @NotNull
    public InputStream getPkcs12StoreStream() {
        return this.pkcs12StoreStream;
    }

    @NotNull
    public char[] getStorePassword() {
        return (char[])this.storePassword.clone();
    }

    @NotNull
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @NotNull
    public char[] getKeyPassword() {
        return (char[])this.keyPassword.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pkcs12Config{");
        sb.append("pkcs12StoreStream=").append(this.pkcs12StoreStream);
        sb.append(", storePassword=***");
        sb.append(", keyAlias='").append(this.keyAlias).append('\'');
        sb.append(", keyPassword=***");
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pkcs12Config that = (Pkcs12Config)o;
        return MiscUtil.inputStreamEqual(this.pkcs12StoreStream, that.pkcs12StoreStream) && Arrays.equals(this.storePassword, that.storePassword) && this.keyAlias.equals(that.keyAlias) && Arrays.equals(this.keyPassword, that.keyPassword);
    }

    public int hashCode() {
        int result = Objects.hash(this.pkcs12StoreStream, this.keyAlias);
        result = 31 * result + Arrays.hashCode(this.storePassword);
        result = 31 * result + Arrays.hashCode(this.keyPassword);
        return result;
    }

    public static class Pkcs12ConfigBuilder {
        private InputStream pkcs12StoreStream;
        private char[] storePassword;
        private String keyAlias;
        private char[] keyPassword;

        private Pkcs12ConfigBuilder() {
        }

        public Pkcs12ConfigBuilder pkcs12Store(String pkcs12StorePath) {
            return this.pkcs12Store(new File(pkcs12StorePath));
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream is meant to travel outside method")
        public Pkcs12ConfigBuilder pkcs12Store(File pkcs12StorePath) {
            try {
                return this.pkcs12Store(new FileInputStream(pkcs12StorePath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(String.format("error reading PKCS12 store from File [%s]", pkcs12StorePath), e);
            }
        }

        public Pkcs12ConfigBuilder pkcs12Store(InputStream pkcs12StoreStream) {
            this.pkcs12StoreStream = pkcs12StoreStream;
            return this;
        }

        public Pkcs12ConfigBuilder storePassword(char[] storePassword) {
            this.storePassword = (char[])storePassword.clone();
            return this;
        }

        public Pkcs12ConfigBuilder storePassword(String storePassword) {
            this.storePassword = storePassword.toCharArray();
            return this;
        }

        public Pkcs12ConfigBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Pkcs12ConfigBuilder keyPassword(char[] keyPassword) {
            this.keyPassword = (char[])keyPassword.clone();
            return this;
        }

        public Pkcs12ConfigBuilder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword.toCharArray();
            return this;
        }

        public Pkcs12Config build() {
            return new Pkcs12Config(this.pkcs12StoreStream, this.storePassword, this.keyAlias, this.keyPassword);
        }
    }
}

