/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.simpleframework.transport.BufferCompacter;
import org.simpleframework.transport.BufferSegment;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketWriter;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.trace.Trace;

class SocketWriter
implements PacketWriter {
    private BufferCompacter compacter;
    private SocketChannel channel;
    private Trace trace;
    private boolean closed;

    public SocketWriter(Socket socket) {
        this(socket, 20480);
    }

    public SocketWriter(Socket socket, int limit) {
        this.compacter = new BufferCompacter(limit);
        this.channel = socket.getChannel();
        this.trace = socket.getTrace();
    }

    public synchronized SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized boolean isBlocking() throws IOException {
        return this.compacter.isReference();
    }

    public synchronized boolean write(Packet packet) throws IOException {
        BufferSegment segment = this.compacter.build(packet);
        if (segment == null) {
            return true;
        }
        return this.flush();
    }

    private synchronized int write(BufferSegment segment) throws IOException {
        int size = segment.write(this.channel);
        int left = segment.length();
        if (left == 0) {
            segment.close();
        }
        if (this.trace != null) {
            this.trace.trace((Object)TransportEvent.WRITE, size);
        }
        if (size < 0) {
            throw new TransportException("Socket is closed");
        }
        return size;
    }

    public synchronized boolean flush() throws IOException {
        BufferSegment segment = this.compacter.build();
        while (segment != null) {
            int size = this.write(segment);
            if (size < 0) {
                throw new TransportException("Connection reset");
            }
            if (size == 0) break;
            segment = this.compacter.build();
        }
        return this.complete();
    }

    private synchronized boolean complete() throws IOException {
        int count = this.compacter.length();
        if (count > 0) {
            this.compacter.compact();
        }
        return count <= 0;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.compacter.close();
            try {
                this.trace.trace((Object)TransportEvent.CLOSE);
                this.channel.socket().shutdownOutput();
            }
            catch (Throwable cause) {
                this.trace.trace((Object)TransportEvent.ERROR, cause);
            }
            this.channel.close();
        }
    }
}

