/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

class Tape {
    static final char ROOT = 'r';
    static final char START_ARRAY = '[';
    static final char START_OBJECT = '{';
    static final char END_ARRAY = ']';
    static final char END_OBJECT = '}';
    static final char STRING = '\"';
    static final char INT64 = 'l';
    static final char DOUBLE = 'd';
    static final char TRUE_VALUE = 't';
    static final char FALSE_VALUE = 'f';
    static final char NULL_VALUE = 'n';
    private static final long JSON_VALUE_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int JSON_COUNT_MASK = 0xFFFFFF;
    private final long[] tape;
    private int tapeIdx;

    Tape(int capacity) {
        this.tape = new long[capacity];
    }

    void append(long val, char type) {
        this.tape[this.tapeIdx] = val | (long)type << 56;
        ++this.tapeIdx;
    }

    void appendInt64(long val) {
        this.append(0L, 'l');
        this.tape[this.tapeIdx] = val;
        ++this.tapeIdx;
    }

    void appendDouble(double val) {
        this.append(0L, 'd');
        this.tape[this.tapeIdx] = Double.doubleToRawLongBits(val);
        ++this.tapeIdx;
    }

    void write(int idx, long val, char type) {
        this.tape[idx] = val | (long)type << 56;
    }

    void skip() {
        ++this.tapeIdx;
    }

    void reset() {
        this.tapeIdx = 0;
    }

    int getCurrentIdx() {
        return this.tapeIdx;
    }

    char getType(int idx) {
        return (char)(this.tape[idx] >> 56);
    }

    long getValue(int idx) {
        return this.tape[idx] & 0xFFFFFFFFFFFFFFL;
    }

    long getInt64Value(int idx) {
        return this.tape[idx + 1];
    }

    double getDouble(int idx) {
        long bits = this.getInt64Value(idx);
        return Double.longBitsToDouble(bits);
    }

    int getMatchingBraceIndex(int idx) {
        return (int)this.tape[idx];
    }

    int getScopeCount(int idx) {
        return (int)(this.tape[idx] >> 32 & 0xFFFFFFL);
    }

    int computeNextIndex(int idx) {
        switch (this.getType(idx)) {
            case '[': 
            case '{': {
                return this.getMatchingBraceIndex(idx);
            }
            case 'd': 
            case 'l': {
                return idx + 2;
            }
        }
        return idx + 1;
    }
}

