/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.BitIndexes;
import org.simdjson.BlockReader;
import org.simdjson.JsonIterator;
import org.simdjson.JsonValue;
import org.simdjson.StructuralIndexer;

public class SimdJsonParser {
    private static final int STEP_SIZE = 64;
    private static final int PADDING = 64;
    private static final int DEFAULT_CAPACITY = 0x2200000;
    private static final int DEFAULT_MAX_DEPTH = 1024;
    private final BlockReader reader;
    private final StructuralIndexer indexer;
    private final BitIndexes bitIndexes;
    private final JsonIterator jsonIterator;
    private final byte[] paddedBuffer;

    public SimdJsonParser() {
        this(0x2200000, 1024);
    }

    public SimdJsonParser(int capacity, int maxDepth) {
        this.bitIndexes = new BitIndexes(capacity);
        this.jsonIterator = new JsonIterator(this.bitIndexes, capacity, maxDepth, 64);
        this.paddedBuffer = new byte[capacity];
        this.reader = new BlockReader(64);
        this.indexer = new StructuralIndexer(this.bitIndexes);
    }

    public JsonValue parse(byte[] buffer, int len) {
        byte[] padded = this.padIfNeeded(buffer, len);
        this.reset(padded, len);
        this.stage1(padded);
        return this.stage2(padded, len);
    }

    private byte[] padIfNeeded(byte[] buffer, int len) {
        if (buffer.length - len < 64) {
            System.arraycopy(buffer, 0, this.paddedBuffer, 0, len);
            return this.paddedBuffer;
        }
        return buffer;
    }

    private void reset(byte[] buffer, int len) {
        this.indexer.reset();
        this.reader.reset(buffer, len);
        this.bitIndexes.reset();
        this.jsonIterator.reset();
    }

    private void stage1(byte[] buffer) {
        while (this.reader.hasFullBlock()) {
            int blockIndex = this.reader.getBlockIndex();
            this.indexer.step(buffer, blockIndex, blockIndex);
            this.reader.advance();
        }
        this.indexer.step(this.reader.remainder(), 0, this.reader.getBlockIndex());
        this.reader.advance();
        this.indexer.finish(this.reader.getBlockIndex());
    }

    private JsonValue stage2(byte[] buffer, int len) {
        return this.jsonIterator.walkDocument(buffer, len);
    }
}

