/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import java.util.Arrays;

class BlockReader {
    private static final byte SPACE = 32;
    private final int stepSize;
    private final byte[] lastBlock;
    private final byte[] spaces;
    private byte[] buffer;
    private int len;
    private int idx = 0;
    private int lenMinusStep;

    BlockReader(int stepSize) {
        this.stepSize = stepSize;
        this.lastBlock = new byte[stepSize];
        this.spaces = new byte[stepSize];
        Arrays.fill(this.spaces, (byte)32);
    }

    void reset(byte[] buffer, int len) {
        this.idx = 0;
        this.len = len;
        this.buffer = buffer;
        this.lenMinusStep = len < this.stepSize ? 0 : len - this.stepSize;
    }

    boolean hasFullBlock() {
        return this.idx < this.lenMinusStep;
    }

    byte[] remainder() {
        System.arraycopy(this.spaces, 0, this.lastBlock, 0, this.lastBlock.length);
        System.arraycopy(this.buffer, this.idx, this.lastBlock, 0, this.len - this.idx);
        return this.lastBlock;
    }

    void advance() {
        this.idx += this.stepSize;
    }

    int getBlockIndex() {
        return this.idx;
    }
}

