/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.silvertunnel_ng.netlib.util.FileUtil;
import org.silvertunnel_ng.netlib.util.StringStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TempfileStringStorage
implements StringStorage {
    private static final Logger LOG = LoggerFactory.getLogger(TempfileStringStorage.class);
    private static final String TEMPDIR = System.getProperty("java.io.tmpdir");
    private static final Pattern KEY_PATTERN = Pattern.compile("[a-z0-9\\_\\-\\.]+");
    private static final String FILENAME_PREFIX = "st-";
    private static FileUtil fileUtil = FileUtil.getInstance();
    private static TempfileStringStorage instance;

    public static TempfileStringStorage getInstance() {
        return instance;
    }

    protected TempfileStringStorage() {
    }

    @Override
    public synchronized void put(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key=null");
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException("invalid characters in key=" + key);
        }
        if (value == null) {
            throw new IllegalArgumentException("value=null");
        }
        try {
            fileUtil.writeFile(this.getTempfileFile(key), value);
        }
        catch (Exception e) {
            LOG.warn("could not write value for key=" + key, (Throwable)e);
        }
    }

    @Override
    public synchronized String get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key=null");
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException("invalid characters in key=" + key);
        }
        try {
            return fileUtil.readFile(this.getTempfileFile(key));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.warn("could not read value for key=" + key, (Throwable)e);
            return null;
        }
    }

    protected File getTempfileFile(String key) throws IOException {
        String prefix = FILENAME_PREFIX + key;
        return new File(TEMPDIR, prefix);
    }

    static {
        LOG.debug("TempfileStringStorage directory={}", (Object)TEMPDIR);
        instance = new TempfileStringStorage();
    }
}

