/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.util;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtilResponseReceiverThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtilResponseReceiverThread.class);
    private static final int DEFAULT_MAX_RESULT_SIZE = 10000000;
    private volatile boolean stopThread;
    private volatile boolean finished;
    private final byte[] tempResultBuffer;
    private volatile int tempResultBufferLen;
    private final InputStream is;

    public HttpUtilResponseReceiverThread(InputStream is) {
        this(is, 10000000);
    }

    public HttpUtilResponseReceiverThread(InputStream is, int maxResultSize) {
        this.is = is;
        this.tempResultBuffer = new byte[maxResultSize];
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            int lastLen;
            while (!this.stopThread && this.tempResultBufferLen < this.tempResultBuffer.length && (lastLen = this.is.read(this.tempResultBuffer, this.tempResultBufferLen, this.tempResultBuffer.length - this.tempResultBufferLen)) >= 0) {
                this.tempResultBufferLen += lastLen;
            }
        }
        catch (IOException e) {
            LOG.error("receiving data interupted by exception", (Throwable)e);
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public byte[] readCurrentResultAndStopThread() {
        int len = this.tempResultBufferLen;
        byte[] result = new byte[len];
        System.arraycopy(this.tempResultBuffer, 0, result, 0, len);
        this.stopThread = true;
        this.finished = true;
        return result;
    }
}

