/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final String FILE_CHARSET_NAME = "UTF-8";
    private static FileUtil instance = new FileUtil();
    private static final int BUFFER_SIZE = 1024;

    public static FileUtil getInstance() {
        return instance;
    }

    protected FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file, String content) throws IOException {
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FILE_CHARSET_NAME));
        try {
            output.write(content);
        }
        finally {
            ((Writer)output).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(File file) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), FILE_CHARSET_NAME));
        try {
            int len;
            StringBuilder contents = new StringBuilder(1024);
            char[] charBuffer = new char[1024];
            while ((len = input.read(charBuffer)) > 0) {
                contents.append(charBuffer, 0, len);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            input.close();
        }
    }

    public String readFileFromClasspath(String filePath) throws IOException {
        return this.readFileFromInputStream(this.getClass().getResourceAsStream(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileFromInputStream(InputStream is) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(is, FILE_CHARSET_NAME));
        try {
            int len;
            StringBuilder contents = new StringBuilder(1024);
            char[] charBuffer = new char[1024];
            while ((len = input.read(charBuffer)) > 0) {
                contents.append(charBuffer, 0, len);
            }
            String string = contents.toString().replaceAll("\r\n", "\n");
            return string;
        }
        finally {
            input.close();
        }
    }
}

