/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayUtil.class);
    private static final char SPECIAL_CHAR = '?';

    public static String showAsString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            result.append(ByteArrayUtil.asChar(b[i]));
        }
        return result.toString();
    }

    public static String showAsStringDetails(byte[] b) {
        StringBuffer result = new StringBuffer(b.length);
        for (int i = 0; i < b.length; ++i) {
            result.append(ByteArrayUtil.asCharDetail(b[i]));
        }
        return result.toString();
    }

    public static byte[] getByteArray(int ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (byte)bytes[i];
        }
        return result;
    }

    public static byte[] getByteArray(String prefixStr, int numOfBytesInTheMiddle, String suffixStr) {
        try {
            byte[] prefix = prefixStr.getBytes("UTF-8");
            byte[] suffix = suffixStr.getBytes("UTF-8");
            byte[] middle = new byte[numOfBytesInTheMiddle];
            for (int i = 0; i < middle.length; ++i) {
                middle[i] = (byte)i;
            }
            byte[] result = new byte[prefix.length + middle.length + suffix.length];
            System.arraycopy(prefix, 0, result, 0, prefix.length);
            System.arraycopy(middle, 0, result, prefix.length, middle.length);
            System.arraycopy(suffix, 0, result, prefix.length + middle.length, suffix.length);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
            return new byte[0];
        }
    }

    public static char asChar(byte b) {
        if (b < 32 || b > 127) {
            return '?';
        }
        return (char)b;
    }

    public static String asCharDetail(byte b) {
        if (b < 32 || b > 127) {
            int i = b < 0 ? 256 + b : b;
            String hex = Integer.toHexString(i);
            if (hex.length() < 2) {
                return "?0" + hex;
            }
            return '?' + hex;
        }
        return Character.toString((char)b);
    }

    public static byte[] readDataFromInputStream(int maxResultSize, InputStream is) throws IOException {
        int len;
        int lastLen;
        byte[] tempResultBuffer = new byte[maxResultSize];
        for (len = 0; len < tempResultBuffer.length && (lastLen = is.read(tempResultBuffer, len, tempResultBuffer.length - len)) >= 0; len += lastLen) {
        }
        byte[] result = new byte[len];
        System.arraycopy(tempResultBuffer, 0, result, 0, len);
        return result;
    }

    public static byte[] concatByteArrays(byte[] ... input) {
        int len = 0;
        for (int i = 0; i < input.length; ++i) {
            len += input[i].length;
        }
        byte[] result = new byte[len];
        int pos = 0;
        for (int i = 0; i < input.length; ++i) {
            System.arraycopy(input[i], 0, result, pos, input[i].length);
            pos += input[i].length;
        }
        return result;
    }
}

