/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.tool;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.silvertunnel_ng.netlib.adapter.url.NetlibURLStreamHandlerFactory;
import org.silvertunnel_ng.netlib.api.NetLayer;
import org.silvertunnel_ng.netlib.api.util.TcpipNetAddress;
import org.silvertunnel_ng.netlib.tool.DynByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleHttpClientCompressed {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHttpClientCompressed.class);
    private static SimpleHttpClientCompressed instance = new SimpleHttpClientCompressed();
    private static final String PROTOCOL_HTTP = "http";

    public static SimpleHttpClientCompressed getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(NetLayer netLayer, TcpipNetAddress hostAndPort, String path) throws IOException, DataFormatException {
        String string;
        String urlStr = null;
        FilterInputStream in = null;
        long startTime = System.currentTimeMillis();
        try {
            int count;
            if (LOG.isDebugEnabled()) {
                LOG.debug("start download with hostAndPort=" + hostAndPort + " and path=" + path);
            }
            NetlibURLStreamHandlerFactory factory = new NetlibURLStreamHandlerFactory(false);
            factory.setNetLayerForHttpHttpsFtp(netLayer);
            if (path != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            path = path + ".z";
            urlStr = "http://" + hostAndPort.getHostnameOrIpaddress() + ":" + hostAndPort.getPort() + path;
            URLStreamHandler handler = factory.createURLStreamHandler(PROTOCOL_HTTP);
            URL context = null;
            URL url = new URL(context, urlStr, handler);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.connect();
            if (!(conn instanceof HttpURLConnection)) throw new IOException("http response code could not be determined for url=" + urlStr);
            HttpURLConnection httpConnection = (HttpURLConnection)conn;
            int code = httpConnection.getResponseCode();
            if (code < 200) throw new IOException("http transfer was not successful for url=" + urlStr);
            if (code >= 300) {
                throw new IOException("http transfer was not successful for url=" + urlStr);
            }
            in = new DataInputStream(conn.getInputStream());
            DynByteBuffer byteBuffer = new DynByteBuffer(conn.getContentLengthLong());
            byte[] buffer = new byte[512000];
            while ((count = ((DataInputStream)in).read(buffer)) > 0) {
                byteBuffer.append(buffer, 0, count);
            }
            long timeReceived = System.currentTimeMillis();
            Inflater inflater = new Inflater();
            inflater.setInput(byteBuffer.toArray());
            byteBuffer.init();
            while (!inflater.finished()) {
                int len = inflater.inflate(buffer);
                byteBuffer.append(buffer, 0, len);
            }
            String response = new String(byteBuffer.toArray(), "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug("end download with hostAndPort=" + hostAndPort + " and path=" + path + " finished with result of length=" + response.length() + " timeReceived : " + (timeReceived - startTime) + " ms timeDecompress : " + (System.currentTimeMillis() - timeReceived) + " ms");
            }
            string = response;
            if (in == null) return string;
        }
        catch (IOException e) {
            try {
                if (!LOG.isDebugEnabled()) throw e;
                LOG.debug("end download with hostAndPort=" + hostAndPort + " and path=" + path + " with " + e, (Throwable)e);
                throw e;
                catch (DataFormatException e2) {
                    if (!LOG.isDebugEnabled()) throw e2;
                    LOG.debug("end download with hostAndPort=" + hostAndPort + " and path=" + path + " with " + e2, (Throwable)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    LOG.warn("Exception while closing InputStream from url=" + urlStr);
                }
                throw throwable;
            }
        }
        try {
            in.close();
            return string;
        }
        catch (IOException e) {
            LOG.warn("Exception while closing InputStream from url=" + urlStr);
        }
        return string;
    }
}

