/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.tool;

import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetFactory;
import org.silvertunnel_ng.netlib.api.NetLayerIDs;
import org.silvertunnel_ng.netlib.api.NetSocket;
import org.silvertunnel_ng.netlib.api.impl.InterconnectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetProxySingleConnectionThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(NetProxySingleConnectionThread.class);
    private final NetSocket upperLayerNetSocket;
    private final NetLayerIDs lowerNetLayerId;
    private static long id;

    public NetProxySingleConnectionThread(NetSocket upperLayerNetSocket, NetLayerIDs lowerNetLayerId) {
        super(NetProxySingleConnectionThread.createUniqueThreadName());
        this.upperLayerNetSocket = upperLayerNetSocket;
        this.lowerNetLayerId = lowerNetLayerId;
    }

    @Override
    public void run() {
        try {
            NetAddress remoteAddress = null;
            NetSocket lowerLayerNetSocket = NetFactory.getInstance().getNetLayerById(this.lowerNetLayerId).createNetSocket(null, null, remoteAddress);
            InterconnectUtil.relay(this.upperLayerNetSocket, lowerLayerNetSocket);
        }
        catch (Exception e) {
            LOG.warn("connection abborted", (Throwable)e);
        }
    }

    protected static synchronized String createUniqueThreadName() {
        return NetProxySingleConnectionThread.class.getName() + ++id;
    }
}

