/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.tool;

import org.silvertunnel_ng.netlib.tool.ByteUtils;

public class DynByteBuffer {
    private static final int DEFAULT_START_SIZE = 10000;
    private static final int DEFAULT_INC_SIZE = 10000;
    private transient int length;
    private transient byte[] buffer;
    private transient int crrPosRead = 0;

    public DynByteBuffer() {
        this.setSize(10000L);
    }

    public DynByteBuffer(byte[] data) {
        this.setBuffer(data);
    }

    public DynByteBuffer(long initSize) {
        if (initSize <= 0L) {
            this.setSize(10000L);
        } else {
            this.setSize(initSize);
        }
    }

    private void setSize(long size) {
        if (this.length == 0) {
            this.buffer = new byte[size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size];
        } else {
            byte[] newBuffer = new byte[size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            this.buffer = newBuffer;
        }
    }

    private void increaseSize() {
        this.increaseSize(10000);
    }

    private void increaseSize(int size) {
        this.setSize(this.buffer.length + size);
    }

    public final void append(boolean value) {
        if (this.length + 1 >= this.buffer.length) {
            this.increaseSize();
        }
        this.buffer[this.length] = (byte)(value ? 1 : 0);
        ++this.length;
    }

    public final void append(byte value) {
        if (this.length + 1 >= this.buffer.length) {
            this.increaseSize();
        }
        this.buffer[this.length] = value;
        ++this.length;
    }

    public final void append(byte[] array, boolean saveLength) {
        if (array == null) {
            if (saveLength) {
                this.append(0);
            }
        } else {
            if (saveLength) {
                this.append(array.length);
            }
            this.append(array, 0, array.length);
        }
    }

    public final void append(byte[] array, int offset) {
        this.append(array, offset, array.length - offset);
    }

    public final void append(byte[] array, int offset, int length) {
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException(length + offset);
        }
        if (this.length + length >= this.buffer.length) {
            if (length > 10000) {
                this.increaseSize(length + 10000);
            } else {
                this.increaseSize();
            }
        }
        System.arraycopy(array, offset, this.buffer, this.length, length);
        this.length += length;
    }

    public final byte[] toArray() {
        return this.toArray(0);
    }

    public final byte[] toArray(int offset) {
        byte[] tmp = new byte[this.length - offset];
        System.arraycopy(this.buffer, offset, tmp, 0, this.length - offset);
        return tmp;
    }

    public final void init() {
        this.length = 0;
    }

    public final void append(int value) {
        this.append(ByteUtils.intToBytes(value), false);
    }

    public final void append(long value) {
        this.append(ByteUtils.longToBytes(value), false);
    }

    public final void append(Long value) {
        this.append(ByteUtils.longToBytes(value), false);
    }

    public final void append(String value) {
        if (value == null || value.isEmpty()) {
            this.append(0);
            return;
        }
        this.append(value.getBytes(), true);
    }

    public final int getSize() {
        return this.buffer.length;
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final void resetPosition() {
        this.resetPosition(0);
    }

    public final void resetPosition(int pos) {
        this.crrPosRead = pos;
    }

    public final int getNextInt() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        int tmp = ByteUtils.bytesToInt(this.buffer, this.crrPosRead);
        this.crrPosRead += 4;
        return tmp;
    }

    public final long getNextLong() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        long tmp = ByteUtils.bytesToLong(this.buffer, this.crrPosRead);
        this.crrPosRead += 8;
        return tmp;
    }

    public final byte getNextByte() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        byte tmp = this.buffer[this.crrPosRead];
        ++this.crrPosRead;
        return tmp;
    }

    public final boolean getNextBoolean() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        byte tmp = this.getNextByte();
        return tmp == 1;
    }

    public final byte[] getNextByteArray() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        int len = this.getNextInt();
        return this.getNextByteArray(len);
    }

    public final String getNextString() {
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        byte[] tmp = this.getNextByteArray();
        if (tmp == null || tmp.length == 0) {
            return null;
        }
        return new String(tmp);
    }

    public final byte[] getNextByteArray(int length) {
        if (length == 0) {
            return null;
        }
        if (this.crrPosRead >= this.length) {
            throw new ArrayIndexOutOfBoundsException(this.crrPosRead);
        }
        byte[] tmp = new byte[length];
        System.arraycopy(this.buffer, this.crrPosRead, tmp, 0, length);
        this.crrPosRead += length;
        return tmp;
    }

    public final void setBuffer(byte[] data) {
        this.buffer = new byte[data.length];
        System.arraycopy(data, 0, this.buffer, 0, data.length);
        this.length = data.length;
        this.crrPosRead = 0;
    }
}

