/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.nameservice.mock;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockNetAddressNameService
implements NetAddressNameService {
    private static final Logger LOG = LoggerFactory.getLogger(MockNetAddressNameService.class);
    private final Map<String, NetAddress[]> name2AddressesMapping;
    private final Map<NetAddress, String[]> address2NamesMapping;

    public MockNetAddressNameService(Map<String, NetAddress> name2AddressMapping, Map<NetAddress, String> address2NameMapping) {
        if (name2AddressMapping == null) {
            throw new NullPointerException("invalid name2AddressMapping=null");
        }
        if (address2NameMapping == null) {
            throw new NullPointerException("invalid address2NameMapping=null");
        }
        this.name2AddressesMapping = new HashMap<String, NetAddress[]>(name2AddressMapping.size());
        for (Map.Entry<String, NetAddress> entry : name2AddressMapping.entrySet()) {
            this.name2AddressesMapping.put(entry.getKey(), new NetAddress[]{entry.getValue()});
        }
        this.address2NamesMapping = new HashMap<NetAddress, String[]>(address2NameMapping.size());
        for (Map.Entry<Object, Object> entry : address2NameMapping.entrySet()) {
            this.address2NamesMapping.put((NetAddress)entry.getKey(), new String[]{(String)entry.getValue()});
        }
    }

    public MockNetAddressNameService(Map<String, NetAddress[]> name2AddressesMapping, Map<NetAddress, String[]> address2NamesMapping, boolean details) {
        if (name2AddressesMapping == null) {
            throw new NullPointerException("invalid name2AddressesMapping=null");
        }
        if (address2NamesMapping == null) {
            throw new NullPointerException("invalid address2NamesMapping=null");
        }
        this.name2AddressesMapping = name2AddressesMapping;
        this.address2NamesMapping = address2NamesMapping;
    }

    @Override
    public NetAddress[] getAddressesByName(String name) throws UnknownHostException {
        NetAddress[] result = this.name2AddressesMapping.get(name);
        if (result != null && result.length > 0) {
            return result;
        }
        throw new UnknownHostException("name=" + name + " could not be resolved");
    }

    @Override
    public String[] getNamesByAddress(NetAddress address) throws UnknownHostException {
        String[] result = this.address2NamesMapping.get(address);
        if (result != null && result.length > 0) {
            return result;
        }
        throw new UnknownHostException("address=" + address + " could not be resolved");
    }
}

