/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.nameservice.inetaddressimpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.api.util.IpNetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIpNetAddressNameService
implements NetAddressNameService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIpNetAddressNameService.class);
    private Object inetAddressImpl;
    private Method lookupAllHostAddrMethod;
    private Method getHostByAddrMethod;
    private static final String TEST_HOSTNAME = "localhost";
    private static final IpNetAddress TEST_IP = new IpNetAddress("127.0.0.1");
    private static DefaultIpNetAddressNameService instance;

    public DefaultIpNetAddressNameService() throws UnsupportedOperationException {
        try {
            String inetAddressImplClassName = DefaultIpNetAddressNameService.isIPv6Supported() ? "java.net.Inet6AddressImpl" : "java.net.Inet4AddressImpl";
            try {
                NetworkInterface.getByName(null);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            Class<?> clazz = Class.forName(inetAddressImplClassName);
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.inetAddressImpl = constructor.newInstance(new Object[0]);
            this.lookupAllHostAddrMethod = clazz.getDeclaredMethod("lookupAllHostAddr", String.class);
            this.lookupAllHostAddrMethod.setAccessible(true);
            this.getHostByAddrMethod = clazz.getDeclaredMethod("getHostByAddr", new byte[0].getClass());
            this.getHostByAddrMethod.setAccessible(true);
            this.checkThatReflectionWorks();
        }
        catch (UnsupportedOperationException e) {
            LOG.error("error during initialization (1)", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error("error during initialization (2)", e);
            throw new UnsupportedOperationException("error during initialization (2)", e);
        }
    }

    private void checkThatReflectionWorks() throws UnsupportedOperationException {
        try {
            this.getAddressesByName(TEST_HOSTNAME);
            this.getNamesByAddress(TEST_IP);
        }
        catch (UnknownHostException e) {
            LOG.debug("got UnknownHostException", (Throwable)e);
        }
    }

    private static boolean isIPv6Supported() {
        return false;
    }

    @Override
    public NetAddress[] getAddressesByName(String hostname) throws UnknownHostException, UnsupportedOperationException {
        if (hostname == null) {
            throw new UnknownHostException("hostname=null");
        }
        try {
            Object inetAddressesObj = this.lookupAllHostAddrMethod.invoke(this.inetAddressImpl, hostname);
            if (inetAddressesObj == null) {
                throw new UnknownHostException("hostname=" + hostname + " could not be resolved");
            }
            if (inetAddressesObj instanceof byte[][]) {
                byte[][] inetAddresses = (byte[][])inetAddressesObj;
                NetAddress[] result = new NetAddress[inetAddresses.length];
                for (int i = 0; i < inetAddresses.length; ++i) {
                    result[i] = new IpNetAddress(inetAddresses[i]);
                }
                return result;
            }
            InetAddress[] inetAddresses = (InetAddress[])inetAddressesObj;
            NetAddress[] result = new NetAddress[inetAddresses.length];
            for (int i = 0; i < inetAddresses.length; ++i) {
                result[i] = new IpNetAddress(inetAddresses[i]);
            }
            return result;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof UnknownHostException) {
                throw (UnknownHostException)e.getTargetException();
            }
            throw new UnsupportedOperationException("resolution failed (1) for hostname=" + hostname, e);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("resolution failed (2) for hostname=" + hostname, e);
        }
    }

    @Override
    public String[] getNamesByAddress(NetAddress ipaddress) throws UnknownHostException, UnsupportedOperationException {
        if (ipaddress == null) {
            throw new UnknownHostException("ipaddress=null");
        }
        if (!(ipaddress instanceof IpNetAddress)) {
            throw new UnknownHostException("ipaddress is not of type IpNetAddress: " + ipaddress);
        }
        IpNetAddress ipNetAddress = (IpNetAddress)ipaddress;
        try {
            String hostname = (String)this.getHostByAddrMethod.invoke(this.inetAddressImpl, new Object[]{ipNetAddress.getIpaddress()});
            if (hostname == null) {
                throw new UnknownHostException("ipaddress=" + ipNetAddress + " could not be resolved");
            }
            return new String[]{hostname};
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof UnknownHostException) {
                throw (UnknownHostException)e.getTargetException();
            }
            throw new UnsupportedOperationException("resolution failed (1) ipaddress=" + ipaddress, e);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("resolution failed (2) ipaddress=" + ipaddress, e);
        }
    }

    public static synchronized DefaultIpNetAddressNameService getInstance() {
        if (instance == null) {
            instance = new DefaultIpNetAddressNameService();
        }
        return instance;
    }
}

