/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.nameservice.cache;

import java.net.UnknownHostException;
import org.silvertunnel_ng.netlib.api.NetAddress;
import org.silvertunnel_ng.netlib.api.NetAddressNameService;
import org.silvertunnel_ng.netlib.nameservice.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingNetAddressNameService
implements NetAddressNameService {
    private static final Logger LOG = LoggerFactory.getLogger(CachingNetAddressNameService.class);
    private static final int DEFAULT_MAX_ELEMENTS_IN_CACHE = 1000;
    private static final boolean DEFAULT_IS_NAME_CASE_SENSITIVE = false;
    private static final int DEFAULT_CACHE_TTL_SECONDS = 60;
    private static final int DEFAULT_CACHE_NEGATIVE_TTL_SECONDS = 60;
    private final NetAddressNameService lowerNetAddressNameService;
    private final boolean isNameCaseSensitive;
    private final Cache<String, NetAddress[]> name2AddressesMappingPositive;
    private final Cache<String, Boolean> name2AddressesMappingNegative;
    private final Cache<NetAddress, String[]> address2NamesMappingPositive;
    private final Cache<NetAddress, Boolean> address2NamesMappingNegative;

    public CachingNetAddressNameService(NetAddressNameService lowerNetAddressNameService) {
        this(lowerNetAddressNameService, 1000, false, 60, 60);
    }

    public CachingNetAddressNameService(NetAddressNameService lowerNetAddressNameService, int maxElementsInCache, boolean isNameCaseSensitive, int cacheTtlSeconds, int cacheNegativeTtlSeconds) {
        this.lowerNetAddressNameService = lowerNetAddressNameService;
        this.isNameCaseSensitive = isNameCaseSensitive;
        this.name2AddressesMappingPositive = new Cache(maxElementsInCache, cacheTtlSeconds);
        this.name2AddressesMappingNegative = new Cache(maxElementsInCache, cacheNegativeTtlSeconds);
        this.address2NamesMappingPositive = new Cache(maxElementsInCache, cacheTtlSeconds);
        this.address2NamesMappingNegative = new Cache(maxElementsInCache, cacheNegativeTtlSeconds);
    }

    @Override
    public NetAddress[] getAddressesByName(String name) throws UnknownHostException {
        NetAddress[] result;
        if (name == null) {
            throw new UnknownHostException("name=null");
        }
        if (!this.isNameCaseSensitive) {
            name = name.toLowerCase();
        }
        if ((result = this.name2AddressesMappingPositive.get(name)) != null) {
            return result;
        }
        Boolean negativeResult = this.name2AddressesMappingNegative.get(name);
        if (Boolean.TRUE == negativeResult) {
            throw new UnknownHostException("name=\"" + name + "\" could be resolved in cache as negative result");
        }
        try {
            result = this.lowerNetAddressNameService.getAddressesByName(name);
            if (result != null) {
                this.name2AddressesMappingPositive.put(name, result);
            }
            return result;
        }
        catch (UnknownHostException e) {
            this.name2AddressesMappingNegative.put(name, Boolean.TRUE);
            throw e;
        }
    }

    @Override
    public String[] getNamesByAddress(NetAddress address) throws UnknownHostException {
        if (address == null) {
            throw new UnknownHostException("address=null");
        }
        String[] result = this.address2NamesMappingPositive.get(address);
        if (result != null) {
            return result;
        }
        Boolean negativeResult = this.address2NamesMappingNegative.get(address);
        if (Boolean.TRUE == negativeResult) {
            throw new UnknownHostException("address=\"" + address + "\" could be resolved in cache as negative result");
        }
        try {
            result = this.lowerNetAddressNameService.getNamesByAddress(address);
            if (result != null) {
                this.address2NamesMappingPositive.put(address, result);
            }
            return result;
        }
        catch (UnknownHostException e) {
            this.address2NamesMappingNegative.put(address, Boolean.TRUE);
            throw e;
        }
    }
}

