/*
 * Decompiled with CFR 0.152.
 */
package org.silvertunnel_ng.netlib.nameservice.cache;

import java.util.Date;
import java.util.Map;

class CacheEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    private V value;
    private Date expires;

    public CacheEntry(K key, V value, int timeToLiveSeconds) {
        this.key = key;
        this.value = value;
        this.expires = new Date(System.currentTimeMillis() + 1000L * (long)timeToLiveSeconds);
    }

    public CacheEntry(V value, Date expires) {
        this.value = value;
        this.expires = expires;
    }

    public boolean isExpired() {
        if (this.expires == null) {
            return false;
        }
        return this.expires.before(new Date());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CacheEntry)) {
            return false;
        }
        CacheEntry e1 = this;
        CacheEntry e2 = (CacheEntry)o;
        return (e1.getKey() == null ? e2.getKey() == null : e1.getKey().equals(e2.getKey())) && (e1.getValue() == null ? e2.getValue() == null : e1.getValue().equals(e2.getValue()));
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "(" + this.key + "," + this.value + "," + this.expires + ")";
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }
}

